/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.curves;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.defaults.curves.CannotFitCurveException;
import nz.org.riskscape.defaults.curves.CurveFitter;
import nz.org.riskscape.defaults.curves.DefaultFitCurve;
import nz.org.riskscape.defaults.curves.FitCurve;
import nz.org.riskscape.defaults.curves.ObservedPoints;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.fitting.SimpleCurveFitter;
import org.apache.commons.math3.util.FastMath;

public class PowerLawFitter
implements CurveFitter<double[]> {
    private static final ParametricUnivariateFunction POLYNOMIAL = new PolynomialFunction.Parametric();
    public JavaParameterSet<Params> parameters = JavaParameterSet.fromBindingClass(Params.class);

    public String getId() {
        return "powerlaw";
    }

    @Override
    public Class<double[]> getBindingClass() {
        return double[].class;
    }

    @Override
    public ResultOrProblems<double[]> bind(BindingContext context, Map<String, List<?>> unbound) {
        BoundParameters bound = this.parameters.bind(context, unbound);
        Params params = (Params)this.parameters.bindToObject(bound).getBoundToObject();
        return ResultOrProblems.of((Object)new double[]{params.linearYIntercept, params.linearSlope});
    }

    @Override
    public FitCurve<double[]> fit(double[] startParams, ObservedPoints points) {
        double[] fitParams;
        SimpleCurveFitter fitter = SimpleCurveFitter.create((ParametricUnivariateFunction)POLYNOMIAL, (double[])startParams);
        try {
            fitParams = fitter.fit(points.withLogXLogY());
        }
        catch (ConvergenceException | MathIllegalArgumentException ex) {
            throw new CannotFitCurveException(Problems.caught((Throwable)ex));
        }
        return new DefaultFitCurve<double[]>(this, this.getFunction(fitParams), fitParams, points, CurveFitter::computeRSquared);
    }

    public UntypedFunction getFunction(double[] coefficients) {
        return args -> {
            double x = ((Number)args.get(0)).doubleValue();
            return Math.exp(POLYNOMIAL.value(FastMath.log((double)x), coefficients));
        };
    }

    @Generated
    public JavaParameterSet<Params> getParameters() {
        return this.parameters;
    }

    public static class Params {
        public double linearYIntercept = 1.0;
        public double linearSlope = -1.0;
    }
}

