/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.curves;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.engine.util.Pair;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.util.FastMath;

public class ObservedPoints
extends AbstractList<WeightedObservedPoint> {
    private final List<Double> xValues;
    private final List<Double> yValues;

    @Override
    public Iterator<WeightedObservedPoint> iterator() {
        return new IterImpl(this.xValues.iterator(), this.yValues.iterator());
    }

    @Override
    public int size() {
        return this.xValues.size();
    }

    @Override
    public WeightedObservedPoint get(int index) {
        Double x = this.xValues.get(index);
        Double y = this.yValues.get(index);
        return new WeightedObservedPoint(1.0, x.doubleValue(), y.doubleValue());
    }

    public List<WeightedObservedPoint> withLogX() {
        return Lists.transform((List)this, point -> new WeightedObservedPoint(point.getWeight(), FastMath.log((double)point.getX()), point.getY()));
    }

    public List<WeightedObservedPoint> withLogY() {
        return Lists.transform((List)this, point -> new WeightedObservedPoint(point.getWeight(), point.getX(), FastMath.log((double)point.getY())));
    }

    public List<WeightedObservedPoint> withLogXLogY() {
        return Lists.transform((List)this, point -> new WeightedObservedPoint(point.getWeight(), FastMath.log((double)point.getX()), FastMath.log((double)point.getY())));
    }

    public List<Pair<Double, Double>> asListOfPairs() {
        return Lists.transform((List)this, point -> Pair.of((Object)point.getX(), (Object)point.getY()));
    }

    public Stream<Double> getYValues() {
        return this.yValues.stream();
    }

    public Stream<Double> getXValues() {
        return this.xValues.stream();
    }

    @Generated
    public ObservedPoints(List<Double> xValues, List<Double> yValues) {
        this.xValues = xValues;
        this.yValues = yValues;
    }

    private static class IterImpl
    implements Iterator<WeightedObservedPoint> {
        private final Iterator<Double> xValueIter;
        private final Iterator<Double> yValueIter;

        @Override
        public WeightedObservedPoint next() {
            Double x = this.xValueIter.next();
            Double y = this.yValueIter.next();
            return new WeightedObservedPoint(1.0, x.doubleValue(), y.doubleValue());
        }

        @Override
        public boolean hasNext() {
            return this.xValueIter.hasNext();
        }

        @Generated
        public IterImpl(Iterator<Double> xValueIter, Iterator<Double> yValueIter) {
            this.xValueIter = xValueIter;
            this.yValueIter = yValueIter;
        }
    }
}

