/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.curves;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.defaults.curves.FitCurve;
import nz.org.riskscape.defaults.curves.ObservedPoints;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.problem.ResultOrProblems;
import org.apache.commons.math3.util.FastMath;

public interface CurveFitter<T>
extends Identified {
    public static <T> double computeRSquared(FitCurve<T> curve) {
        ObservedPoints points = curve.getObservedPoints();
        double yMean = points.getYValues().reduce(0.0, (a, b) -> a + b) / (double)points.size();
        double ssTot = points.getYValues().map(y -> FastMath.pow((double)(y - yMean), (int)2)).reduce(0.0, (a, b) -> a + b);
        double ssRes = points.stream().map(point -> {
            double y = point.getY();
            double x = point.getX();
            double computedY = ((Number)curve.getFunction().call(Collections.singletonList(x))).doubleValue();
            return Math.pow(y - computedY, 2.0);
        }).reduce(0.0, (a, b) -> a + b);
        return 1.0 - ssRes / ssTot;
    }

    public ParameterSet getParameters();

    public ResultOrProblems<T> bind(BindingContext var1, Map<String, List<?>> var2);

    public Class<T> getBindingClass();

    public FitCurve<T> fit(T var1, ObservedPoints var2);
}

