/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.curves;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.defaults.curves.CannotFitCurveException;
import nz.org.riskscape.defaults.curves.CurveFitter;
import nz.org.riskscape.defaults.curves.DefaultFitCurve;
import nz.org.riskscape.defaults.curves.FitCurve;
import nz.org.riskscape.defaults.curves.ObservedPoints;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class ContinuousLinearFitter
implements CurveFitter<Double> {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public String getId() {
        return "continuous";
    }

    @Override
    public ParameterSet getParameters() {
        return ParameterSet.from((Parameter[])new Parameter[]{Parameter.required((String)"score", Double.class, (Object)0.0)});
    }

    @Override
    public ResultOrProblems<Double> bind(BindingContext context, Map<String, List<?>> unbound) {
        return this.getParameters().bind(context, unbound).flatMap(bound -> ResultOrProblems.of((Object)((Double)bound.getValue("score"))));
    }

    @Override
    public Class<Double> getBindingClass() {
        return Double.class;
    }

    @Override
    public FitCurve<Double> fit(Double score, ObservedPoints points) {
        ArrayList<Pair<Double, Double>> pairs = new ArrayList<Pair<Double, Double>>(points.asListOfPairs());
        pairs.sort((a, b) -> ((Double)a.getLeft()).compareTo((Double)b.getLeft()));
        if (pairs.isEmpty()) {
            throw new CannotFitCurveException(PROBLEMS.noData());
        }
        HashSet<Double> unique = new HashSet<Double>();
        for (Pair pair : pairs) {
            if (unique.add((Double)pair.getLeft())) continue;
            throw new CannotFitCurveException(PROBLEMS.duplicateXValues(this.getId(), (Double)pair.getLeft()));
        }
        double[] xsAndYs = new double[pairs.size() * 2];
        boolean bl = false;
        for (Pair pair : pairs) {
            xsAndYs[var6_8++] = (Double)pair.getLeft();
            xsAndYs[var6_8++] = (Double)pair.getRight();
        }
        return new DefaultFitCurve<Double>(this, this.getFunction(xsAndYs), score, points, x -> score);
    }

    public UntypedFunction getFunction(double[] xsAndYs) {
        return args -> {
            double x = ((Number)args.get(0)).doubleValue();
            int i = 0;
            while (i < xsAndYs.length - 2) {
                double x1 = xsAndYs[i++];
                double y1 = xsAndYs[i++];
                double x2 = xsAndYs[i];
                double y2 = xsAndYs[i + 1];
                if (!(x >= x1) || !(x < x2)) continue;
                double slope = (y2 - y1) / (x2 - x1);
                double yIntercept = y1 - slope * x1;
                return slope * x + yIntercept;
            }
            if (x < xsAndYs[0]) {
                return xsAndYs[1];
            }
            return xsAndYs[xsAndYs.length - 1];
        };
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem noData();

        public Problem duplicateXValues(String var1, Double var2);
    }
}

