/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import java.util.Arrays;
import java.util.regex.Pattern;
import nz.org.riskscape.defaults.classifier.TokenMatchers;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.LexingMatcher;
import nz.org.riskscape.dsl.TokenMatcher;
import nz.org.riskscape.dsl.TokenType;

public enum TokenTypes implements TokenType
{
    IDENTIFIER("([0-9a-zA-Z_\\-]+):(?!:)"),
    QUOTED_IDENTIFIER(TokenMatcher.forQuotedString((char)'\"')),
    SPACE(' ', true),
    TAB('\t', true),
    COMMENT(TokenMatcher.forLineComment((String)"#"), true),
    CR_LF(TokenMatcher.forString((String)"\r\n"), true),
    LF(TokenMatcher.forChar((char)'\n'), true),
    EXPRESSION(TokenMatchers.TRAILING_EXPRESSION),
    EOF("$");

    TokenMatcher matcher;
    boolean whitespace;

    public static Lexer.Tokens<TokenTypes> tokens() {
        return new Lexer.Tokens(TokenTypes.class, (TokenType)EOF, Arrays.asList(LF, CR_LF));
    }

    private TokenTypes(char literal, boolean whitespace) {
        this.whitespace = whitespace;
        this.matcher = TokenMatcher.forChar((char)literal);
    }

    private TokenTypes(char literal) {
        this(literal, false);
    }

    private TokenTypes(TokenMatcher matcher) {
        this.matcher = matcher;
        this.whitespace = false;
    }

    private TokenTypes(TokenMatcher matcher, boolean whitespace) {
        this.matcher = matcher;
        this.whitespace = whitespace;
    }

    private TokenTypes(String regex) {
        this.matcher = TokenMatcher.forPattern((Pattern)Pattern.compile("^" + regex));
    }

    public boolean isWhitespace() {
        return this.whitespace;
    }

    public LexingMatcher matcher() {
        return LexingMatcher.wrap((TokenMatcher)this.matcher);
    }
}

