/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.defaults.classifier.ProblemCodes;
import nz.org.riskscape.defaults.classifier.RealizedTreeExpression;
import nz.org.riskscape.defaults.classifier.RealizedTreeFilter;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ResultOrProblems;

public class ReturnTypeInferer {
    private final RealizedTreeFilter wrapped;
    private final Type resultType;
    private final Map<RealizedTreeExpression, Coercer> coercers;

    public static ResultOrProblems<ReturnTypeInferer> build(RealizedTreeFilter filter, TypeSet typeSet) {
        List<RealizedTreeExpression> collectedExpressions = filter.collectRealizedExpressions();
        return ReturnTypeInferer.inferType(filter, collectedExpressions, typeSet).map(returnType -> {
            HashMap<RealizedTreeExpression, Coercer> coercers = new HashMap<RealizedTreeExpression, Coercer>();
            for (RealizedTreeExpression treeExpression : collectedExpressions) {
                if (typeSet.isAssignable(treeExpression.getResultType(), returnType)) continue;
                Coercer coercer = (Coercer)typeSet.findEquivalenceCoercer(treeExpression.getResultType(), returnType).orElseThrow(() -> new NoSuchElementException());
                coercers.put(treeExpression, coercer);
            }
            return new ReturnTypeInferer(filter, (Type)returnType, (Map<RealizedTreeExpression, Coercer>)coercers);
        });
    }

    private static ResultOrProblems<Type> inferType(RealizedTreeFilter filter, List<RealizedTreeExpression> collectedExpressions, TypeSet typeSet) {
        if (filter.getChildren().size() == 0) {
            return ResultOrProblems.of((Object)filter.getOrElse().resultType);
        }
        RealizedTreeExpression firstExpression = collectedExpressions.get(0);
        boolean wasStruct = firstExpression.getResultType().find(Struct.class).isPresent();
        for (RealizedTreeExpression re : collectedExpressions) {
            boolean alsoStruct;
            if (re == RealizedTreeExpression.EMPTY || (alsoStruct = re.getResultType().find(Struct.class).isPresent()) == wasStruct) continue;
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.MIXED_TREE_RESULT_TYPES, (Object[])new Object[]{firstExpression.expression.getIdentifier().getLocation().getLine(), re.expression.getIdentifier().getLocation().getLine()})});
        }
        boolean hasNoDefault = filter.getOrElse().equals(RealizedTreeExpression.EMPTY);
        Type pointer = null;
        for (RealizedTreeExpression rte : collectedExpressions) {
            if (pointer == null) {
                pointer = rte.getResultType();
                continue;
            }
            pointer = ReturnTypeInferer.findBestReceiverType(pointer, rte.getResultType(), typeSet);
        }
        return ResultOrProblems.of((Object)Nullable.ifTrue((boolean)hasNoDefault, pointer));
    }

    static Type findBestReceiverType(Type a, Type b, TypeSet typeSet) {
        Type previousBestMatch;
        boolean nullable = Nullable.is((Type)a) || Nullable.is((Type)b);
        Object currentBestMatch = previousBestMatch = Nullable.strip((Type)a);
        Type toMatch = Nullable.strip((Type)b);
        Optional currentBestStruct = currentBestMatch.find(Struct.class);
        Optional toMatchStruct = toMatch.find(Struct.class);
        if (currentBestStruct.isPresent() && toMatchStruct.isPresent()) {
            currentBestMatch = ReturnTypeInferer.merge((Struct)currentBestStruct.get(), (Struct)toMatchStruct.get(), typeSet);
        } else if (!typeSet.isAssignable(toMatch, currentBestMatch)) {
            if (typeSet.isAssignable(currentBestMatch, toMatch)) {
                currentBestMatch = toMatch;
            } else if (!typeSet.findEquivalenceCoercer(toMatch, currentBestMatch).isPresent()) {
                currentBestMatch = typeSet.findEquivalenceCoercer(currentBestMatch, toMatch).isPresent() ? toMatch : (currentBestMatch.isWrapped() || toMatch.isWrapped() ? ReturnTypeInferer.findBestReceiverType(currentBestMatch.getUnwrappedType(), toMatch.getUnwrappedType(), typeSet) : Types.ANYTHING);
            }
        }
        return Nullable.ifTrue((boolean)nullable, (Type)currentBestMatch);
    }

    static Struct merge(Struct startWith, Struct toMerge, TypeSet typeSet) {
        Struct merged = startWith;
        for (Struct.StructMember thisMember : toMerge.getMembers()) {
            Struct.StructMember collatedMember = merged.getEntry(thisMember.getKey());
            if (collatedMember == null) {
                merged = merged.add(thisMember.getKey(), Nullable.of((Type)thisMember.getType()));
                continue;
            }
            Type bestMatch = ReturnTypeInferer.findBestReceiverType(collatedMember.getType(), thisMember.getType(), typeSet);
            merged = merged.addOrReplace(thisMember.getKey(), bestMatch);
        }
        for (Struct.StructMember thisMember : merged.getMembers()) {
            if (toMerge.getMember(thisMember.getKey()).isPresent()) continue;
            merged = merged.addOrReplace(thisMember.getKey(), Nullable.of((Type)thisMember.getType()));
        }
        return merged;
    }

    public Object evaluate(Object input) {
        RealizedTreeExpression expression = this.wrapped.match(input);
        if (expression == null) {
            return null;
        }
        Object result = expression.evaluate(input);
        Coercer coercer = this.coercers.get(expression);
        if (coercer != null) {
            result = coercer.apply(result);
        }
        return result;
    }

    boolean isDefaultPresent() {
        return this.wrapped.isDefaultPresent();
    }

    @Generated
    public ReturnTypeInferer(RealizedTreeFilter wrapped, Type resultType, Map<RealizedTreeExpression, Coercer> coercers) {
        this.wrapped = wrapped;
        this.resultType = resultType;
        this.coercers = coercers;
    }

    @Generated
    public RealizedTreeFilter getWrapped() {
        return this.wrapped;
    }

    @Generated
    public Type getResultType() {
        return this.resultType;
    }
}

