/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.defaults.classifier.AST;
import nz.org.riskscape.defaults.classifier.ProblemCodes;
import nz.org.riskscape.defaults.classifier.RealizedTreeExpression;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class RealizedTreeFilter {
    private final AST.Filter filter;
    private final RealizedExpression condition;
    private final RealizedTreeExpression orElse;
    private final List<RealizedTreeFilter> children;
    private int maxDepth = 10;
    private boolean exclusive = true;

    public static ResultOrProblems<RealizedTreeFilter> build(ExpressionRealizer realizer, AST.FunctionDecl function, Type inputType) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (function.body.isEmpty() && !function.defaultExpr.isPresent()) {
            problems.add(Problem.error((ProblemCode)ProblemCodes.EMPTY_BODY, (Object[])new Object[0]));
            return ResultOrProblems.failed(problems);
        }
        RealizedTreeExpression defaultExpr = RealizedTreeExpression.EMPTY;
        if (function.defaultExpr.isPresent()) {
            ResultOrProblems<RealizedTreeExpression> exprOr = RealizedTreeExpression.build(realizer, function.defaultExpr.get(), inputType);
            if (exprOr.hasProblems()) {
                problems.add(Problems.foundWith((Object)function.defaultExpr.get().getIdentifier(), (List)exprOr.getProblems()));
            }
            defaultExpr = (RealizedTreeExpression)exprOr.orElse((Object)RealizedTreeExpression.EMPTY);
        }
        ArrayList<RealizedTreeFilter> realizedFilters = new ArrayList<RealizedTreeFilter>();
        for (AST.Filter filterAst : function.body) {
            ResultOrProblems<RealizedTreeFilter> filterOr = RealizedTreeFilter.build(realizer, filterAst, inputType);
            if (filterOr.hasProblems()) {
                problems.add(Problems.foundWith((Object)filterAst.getIdentifier(), (List)filterOr.getProblems()));
            }
            if (!filterOr.isPresent()) continue;
            realizedFilters.add((RealizedTreeFilter)filterOr.getWithProblemsIgnored());
        }
        RealizedTreeFilter rtf = new RealizedTreeFilter(null, RealizedExpression.TRUE, defaultExpr, realizedFilters);
        return ResultOrProblems.of((Object)rtf, problems);
    }

    public static ResultOrProblems<RealizedTreeFilter> build(ExpressionRealizer realizer, AST.Filter filter, Type inputType) {
        ArrayList<RealizedTreeFilter> children = new ArrayList<RealizedTreeFilter>(filter.children.size());
        ArrayList<Problem> filterProblems = new ArrayList<Problem>();
        if (filter.children.isEmpty() && !filter.orElse.isPresent()) {
            filterProblems.add(Problem.error((ProblemCode)ProblemCodes.EMPTY_FILTER, (Object[])new Object[]{filter.identifier.getLocation().getLine()}));
        }
        for (AST.Filter childFilter : filter.children) {
            ResultOrProblems<RealizedTreeFilter> filterOr = RealizedTreeFilter.build(realizer, childFilter, inputType);
            if (filterOr.hasProblems()) {
                filterProblems.add(Problems.foundWith((Object)childFilter.getIdentifier(), (List)filterOr.getProblems()));
            }
            if (!filterOr.isPresent()) continue;
            children.add((RealizedTreeFilter)filterOr.get());
        }
        ResultOrProblems expressionOr = realizer.realize(inputType, filter.built);
        ResultOrProblems funcOr = filter.orElse.map(e -> RealizedTreeExpression.build(realizer, e, inputType)).map(exprOr -> {
            if (exprOr.hasProblems()) {
                filterProblems.add(Problems.foundWith((Object)filter.orElse.get().getIdentifier(), (List)exprOr.getProblems()));
            }
            return exprOr;
        }).orElse(null);
        if (expressionOr.isPresent()) {
            return ResultOrProblems.of((Object)new RealizedTreeFilter(filter, (RealizedExpression)expressionOr.get(), funcOr == null ? null : (RealizedTreeExpression)funcOr.orElse(null), children), filterProblems);
        }
        filterProblems.add(Problems.foundWith((Object)filter.built, (List)expressionOr.getProblems()));
        return ResultOrProblems.failed(filterProblems);
    }

    static final RealizedTreeFilter fallback(RealizedTreeExpression yield) {
        return new RealizedTreeFilter(null, RealizedExpression.TRUE, yield, Collections.emptyList());
    }

    public Object evaluate(Object input) {
        RealizedTreeExpression expression = this.match(input);
        if (expression == null) {
            return null;
        }
        return expression.evaluate(input);
    }

    public RealizedTreeExpression match(Object criteria) {
        ArrayList<RealizedTreeFilter> visitStack = new ArrayList<RealizedTreeFilter>(this.maxDepth);
        visitStack.add(this);
        while (!visitStack.isEmpty()) {
            RealizedTreeFilter ptr = (RealizedTreeFilter)visitStack.remove(0);
            if (ptr.condition.evaluate(criteria) != Boolean.TRUE) continue;
            if (ptr.children.isEmpty()) {
                return ptr.orElse;
            }
            if (this.exclusive) {
                visitStack.clear();
            }
            visitStack.addAll(ptr.children);
            if (ptr.orElse == null) continue;
            visitStack.add(RealizedTreeFilter.fallback(ptr.orElse));
        }
        return this.orElse;
    }

    boolean isDefaultPresent() {
        return this.orElse != null && this.orElse != RealizedTreeExpression.EMPTY;
    }

    public String toString() {
        if (this.children.size() == 0) {
            return String.format("RealizedTreeFilter(if=%s, then=%s)", this.condition, this.orElse);
        }
        return String.format("RealizedTreeFilter(if=%s, nested=%s, default=%s)", this.condition, this.children, this.orElse);
    }

    public List<RealizedTreeExpression> collectRealizedExpressions() {
        LinkedList<RealizedTreeFilter> stack = new LinkedList<RealizedTreeFilter>();
        stack.add(this);
        ArrayList<RealizedTreeExpression> collected = new ArrayList<RealizedTreeExpression>();
        while (!stack.isEmpty()) {
            RealizedTreeFilter ptr = (RealizedTreeFilter)stack.removeFirst();
            stack.addAll(ptr.children);
            if (ptr.orElse == null || ptr.orElse == RealizedTreeExpression.EMPTY) continue;
            collected.add(ptr.orElse);
        }
        return collected;
    }

    @Generated
    public RealizedTreeFilter(AST.Filter filter, RealizedExpression condition, RealizedTreeExpression orElse, List<RealizedTreeFilter> children) {
        this.filter = filter;
        this.condition = condition;
        this.orElse = orElse;
        this.children = children;
    }

    @Generated
    public RealizedExpression getCondition() {
        return this.condition;
    }

    @Generated
    public RealizedTreeExpression getOrElse() {
        return this.orElse;
    }

    @Generated
    public List<RealizedTreeFilter> getChildren() {
        return this.children;
    }
}

