/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.defaults.classifier.AST;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class RealizedTreeExpression {
    public static final RealizedTreeExpression EMPTY = new RealizedTreeExpression(null, (Type)Nullable.ANYTHING){

        @Override
        public Object evaluate(Object scope) {
            return null;
        }
    };
    protected final AST.ExpressionDecl expression;
    protected final Type resultType;

    public static ResultOrProblems<RealizedTreeExpression> build(ExpressionRealizer realizer, AST.ExpressionDecl ast, Type inputType) {
        ArrayList problems = new ArrayList();
        if (ast instanceof AST.StructExpression) {
            AST.StructExpression structExpr = (AST.StructExpression)ast;
            ArrayList<RealizedTreeExpression> children = new ArrayList<RealizedTreeExpression>(structExpr.members.size());
            Struct.StructBuilder builder = new Struct.StructBuilder(children.size());
            for (AST.ExpressionDecl decl : structExpr.members) {
                ResultOrProblems<RealizedTreeExpression> expr = RealizedTreeExpression.build(realizer, decl, inputType);
                if (expr.hasErrors()) {
                    problems.addAll(expr.getProblems());
                    continue;
                }
                children.add((RealizedTreeExpression)expr.get());
                builder.add(decl.getIdentifier().value, ((RealizedTreeExpression)expr.get()).getResultType());
            }
            return ResultOrProblems.of((Object)new Structed(structExpr, builder.build(), children), problems);
        }
        AST.SimpleExpression simpleExpr = (AST.SimpleExpression)ast;
        ResultOrProblems realized = realizer.realize(inputType, simpleExpr.built);
        if (realized.isPresent()) {
            return ResultOrProblems.of((Object)new Simple(simpleExpr, (RealizedExpression)realized.get()));
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith((Object)simpleExpr.getIdentifier(), (Problem[])new Problem[0]).withChildren(new Problems[]{Problems.foundWith((Object)simpleExpr.built, (List)realized.getProblems())})});
    }

    public abstract Object evaluate(Object var1);

    @Generated
    public RealizedTreeExpression(AST.ExpressionDecl expression, Type resultType) {
        this.expression = expression;
        this.resultType = resultType;
    }

    @Generated
    public AST.ExpressionDecl getExpression() {
        return this.expression;
    }

    @Generated
    public Type getResultType() {
        return this.resultType;
    }

    private static class Structed
    extends RealizedTreeExpression {
        private List<RealizedTreeExpression> children;
        private Struct struct;

        Structed(AST.StructExpression expression, Struct resultType, List<RealizedTreeExpression> children) {
            super(expression, (Type)resultType);
            this.children = children;
            this.struct = resultType;
        }

        @Override
        public Object evaluate(Object scope) {
            Tuple tuple = new Tuple(this.struct);
            int i = 0;
            for (RealizedTreeExpression child : this.children) {
                tuple.set(i++, child.evaluate(scope));
            }
            return tuple;
        }

        public String toString() {
            return String.format("Structed(%s)", this.children);
        }
    }

    private static class Simple
    extends RealizedTreeExpression {
        private final RealizedExpression realizedExpression;

        Simple(AST.SimpleExpression expression, RealizedExpression realized) {
            super(expression, realized.getResultType());
            this.realizedExpression = realized;
        }

        @Override
        public Object evaluate(Object scope) {
            return this.realizedExpression.evaluate(scope);
        }

        public String toString() {
            return String.format("Simple(%s)", this.expression);
        }
    }
}

