/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.defaults.classifier.AST;
import nz.org.riskscape.defaults.classifier.InvalidClassifierSyntaxException;
import nz.org.riskscape.defaults.classifier.ProblemCodes;
import nz.org.riskscape.defaults.classifier.TokenTypes;
import nz.org.riskscape.defaults.classifier.UnexpectedIdentifierException;
import nz.org.riskscape.defaults.classifier.UnexpectedWhitespaceException;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;

public class ClassifierFunctionParser {
    private static final AST.StructType NO_ARGS = new AST.StructType(Token.token((TokenType)TokenTypes.EOF, (String)""), Collections.emptyList());
    Lexer<TokenTypes> lexer;

    public AST.FunctionDecl parse(String source) {
        this.lexer = new Lexer(TokenTypes.tokens(), source);
        return this.parseFunctionDecl();
    }

    private AST.FunctionDecl parseFunctionDecl() {
        HashMap<IDType, Object> memo = new HashMap<IDType, Object>();
        Token start = null;
        while (!this.lexer.isEOF()) {
            Token identifier = this.lexer.expect(new TokenType[]{TokenTypes.IDENTIFIER});
            if (start == null) {
                start = identifier;
            }
            Object parsed = null;
            IDType ident = IDType.of(identifier.value);
            switch (ident) {
                case ID: 
                case DESCRIPTION: 
                case CATEGORY: {
                    parsed = this.parseMetadata(identifier);
                    break;
                }
                case RETURN_TYPE: 
                case ARGUMENT_TYPES: {
                    parsed = this.parseTypeDecl(identifier);
                    break;
                }
                case BEFORE: 
                case AFTER: 
                case DEFAULT: 
                case DO: {
                    parsed = this.parseExpression(identifier);
                    break;
                }
                case WHEN: {
                    List filters = memo.getOrDefault((Object)ident, new ArrayList());
                    filters.add(this.parseTree(identifier));
                    parsed = filters;
                    break;
                }
                default: {
                    throw new UnexpectedIdentifierException(identifier, IDType.ARGUMENT_TYPES.getLabels(), IDType.ID.getLabels(), IDType.DESCRIPTION.getLabels(), IDType.CATEGORY.getLabels(), IDType.RETURN_TYPE.getLabels(), IDType.BEFORE.getLabels(), IDType.AFTER.getLabels(), IDType.DEFAULT.getLabels(), IDType.DO.getLabels(), IDType.WHEN.getLabels());
                }
            }
            if (memo.put(ident, parsed) == null || ident == IDType.WHEN) continue;
            throw new InvalidClassifierSyntaxException(Problem.error((ProblemCode)ProblemCodes.REDEFINITION, (Object[])new Object[]{identifier.value}));
        }
        if (memo.containsKey((Object)IDType.DEFAULT) && memo.containsKey((Object)IDType.DO)) {
            AST.ExpressionDecl functionDecl = (AST.ExpressionDecl)memo.get((Object)IDType.DO);
            AST.ExpressionDecl defaultDecl = (AST.ExpressionDecl)memo.get((Object)IDType.DEFAULT);
            throw new InvalidClassifierSyntaxException(Problem.error((ProblemCode)ProblemCodes.FUNCTION_AND_DEFAULT, (Object[])new Object[]{functionDecl.getIdentifier().getLocation().getLine(), defaultDecl.getIdentifier().getLocation().getLine()}));
        }
        memo.putIfAbsent(IDType.DEFAULT, memo.get((Object)IDType.DO));
        return new AST.FunctionDecl(start, Optional.ofNullable((AST.Metadata)memo.get((Object)IDType.ID)), Optional.ofNullable((AST.Metadata)memo.get((Object)IDType.DESCRIPTION)), Optional.ofNullable((AST.Metadata)memo.get((Object)IDType.CATEGORY)), memo.getOrDefault((Object)IDType.ARGUMENT_TYPES, NO_ARGS), Optional.ofNullable((AST.TypeDecl)memo.get((Object)IDType.RETURN_TYPE)), Optional.ofNullable((AST.ExpressionDecl)memo.get((Object)IDType.BEFORE)), memo.getOrDefault((Object)IDType.WHEN, new ArrayList()), Optional.ofNullable((AST.ExpressionDecl)memo.get((Object)IDType.DEFAULT)), Optional.ofNullable((AST.ExpressionDecl)memo.get((Object)IDType.AFTER)));
    }

    private AST.TypeDecl parseTypeDecl(Token identifier) {
        Token trailing = this.parseTrailingIfPresent(identifier);
        if (trailing != null) {
            return new AST.SimpleType(identifier, trailing);
        }
        ArrayList<AST.TypeDecl> children = new ArrayList<AST.TypeDecl>();
        while (!this.lexer.isEOF()) {
            Token token = this.lexer.peek();
            if (token.type != TokenTypes.IDENTIFIER || !token.moreIndented(identifier)) break;
            children.add(this.parseTypeDecl(this.lexer.next()));
        }
        return new AST.StructType(identifier, children);
    }

    private boolean isChild(Token parent, Token compareTo) {
        return compareTo.moreIndented(parent);
    }

    private AST.Filter parseTree(Token identifier) {
        Token filterExpr = this.expectOnSameLine(identifier, TokenTypes.EXPRESSION);
        AST.ExpressionDecl orElse = null;
        ArrayList<AST.Filter> children = new ArrayList<AST.Filter>();
        block4: while (!this.lexer.isEOF()) {
            Token nextIdent = this.lexer.expect(new TokenType[]{TokenTypes.IDENTIFIER});
            if (!nextIdent.moreIndented(identifier)) {
                this.lexer.rewind(nextIdent);
                break;
            }
            IDType ident = IDType.of(nextIdent.value);
            switch (ident) {
                case WHEN: {
                    children.add(this.parseTree(nextIdent));
                    continue block4;
                }
                case DEFAULT: 
                case DO: {
                    orElse = this.parseExpression(nextIdent);
                    continue block4;
                }
            }
            throw new UnexpectedIdentifierException(nextIdent, IDType.WHEN.getLabels(), IDType.DEFAULT.getLabels(), IDType.DO.getLabels());
        }
        return new AST.Filter(identifier, filterExpr, children, Optional.ofNullable(orElse));
    }

    private AST.ExpressionDecl parseExpression(Token identifier) {
        Token childIdentifier;
        IDType identifierType = IDType.of(identifier.value);
        Token trailing = this.parseTrailingIfPresent(identifier);
        if (trailing != null) {
            return new AST.SimpleExpression(identifier, trailing);
        }
        List<Token> trailingTokens = this.parseTrailingWithQuotedIdentifiersIfPresent(identifier);
        if (!trailingTokens.isEmpty()) {
            return new AST.SimpleExpression(identifier, trailingTokens);
        }
        ArrayList<AST.ExpressionDecl> children = new ArrayList<AST.ExpressionDecl>();
        while (!this.lexer.isEOF() && this.isChild(identifier, childIdentifier = this.lexer.peek())) {
            this.lexer.expect(new TokenType[]{TokenTypes.IDENTIFIER});
            AST.ExpressionDecl childExpression = this.parseExpression(childIdentifier);
            IDType childIdentifierType = IDType.of(childIdentifier.value);
            if (identifierType.equals((Object)IDType.DEFAULT) && childIdentifierType.equals((Object)IDType.DO)) {
                if (childExpression instanceof AST.SimpleExpression) {
                    return new AST.SimpleExpression(identifier, ((AST.SimpleExpression)childExpression).getExpressionParts());
                }
                return new AST.StructExpression(identifier, ((AST.StructExpression)childExpression).members);
            }
            children.add(childExpression);
        }
        return new AST.StructExpression(identifier, children);
    }

    private AST.Metadata parseMetadata(Token identifier) {
        Token value = this.expectOnSameLine(identifier, TokenTypes.EXPRESSION, TokenTypes.QUOTED_IDENTIFIER);
        return new AST.Metadata(identifier, value);
    }

    private Token expectOnSameLine(Token anchor, TokenTypes ... expected) {
        Token matched = this.lexer.expect((TokenType[])expected);
        if (matched.getLocation().getLine() != anchor.getLocation().getLine()) {
            throw UnexpectedWhitespaceException.notOnSameLine(anchor, matched);
        }
        return matched;
    }

    private Token parseTrailingIfPresent(Token ident) {
        if (this.lexer.peekType() == TokenTypes.EXPRESSION) {
            Token trailing = this.lexer.next();
            if (trailing.getLocation().getLine() != ident.getLocation().getLine()) {
                throw UnexpectedWhitespaceException.notOnSameLine(ident, trailing);
            }
            return trailing;
        }
        return null;
    }

    private List<Token> parseTrailingWithQuotedIdentifiersIfPresent(Token ident) {
        ArrayList<Token> found = new ArrayList<Token>();
        if (this.lexer.peekType() == TokenTypes.QUOTED_IDENTIFIER) {
            found.add(this.lexer.next());
            Token trailing = this.parseTrailingIfPresent(ident);
            if (trailing != null) {
                found.add(trailing);
            }
        }
        return found;
    }

    private static enum IDType {
        ID("id"),
        DESCRIPTION("description"),
        CATEGORY("category"),
        RETURN_TYPE("return-type"),
        ARGUMENT_TYPES("argument-types"),
        BEFORE("before", "pre"),
        AFTER("after", "post"),
        DEFAULT("default"),
        DO("do", "function"),
        WHEN("when", "filter"),
        UNKNOWN(null);

        private final String label;
        private final String alternate;

        static IDType of(String label) {
            for (IDType id : IDType.values()) {
                if (!label.equals(id.label) && !label.equals(id.alternate)) continue;
                return id;
            }
            return UNKNOWN;
        }

        private IDType(String label) {
            this.label = label;
            this.alternate = null;
        }

        private IDType(String label, String alternate) {
            this.label = label;
            this.alternate = alternate;
        }

        String getLabels() {
            if (this.alternate != null) {
                return String.format("%s or %s", this.label, this.alternate);
            }
            return this.label;
        }
    }
}

