/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.defaults.classifier.AST;
import nz.org.riskscape.defaults.classifier.ClassifierFunctionParser;
import nz.org.riskscape.defaults.classifier.ProblemCodes;
import nz.org.riskscape.defaults.classifier.RealizedTreeExpression;
import nz.org.riskscape.defaults.classifier.RealizedTreeFilter;
import nz.org.riskscape.defaults.classifier.ReturnTypeInferer;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.typexp.DefaultTypeBuilder;
import nz.org.riskscape.engine.typexp.TypeBuilder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ClassifierFunction
implements RiskscapeFunction,
RealizableFunction {
    private final AST.FunctionDecl ast;
    private final Project project;
    private ArgumentList arguments;

    public static ResultOrProblems<ClassifierFunction> build(Project project, String source) {
        AST.FunctionDecl parsed;
        ClassifierFunctionParser functionParser = new ClassifierFunctionParser();
        try {
            parsed = functionParser.parse(source);
        }
        catch (LexerException | ParseException ex) {
            return ResultOrProblems.error((RiskscapeException)ex);
        }
        return ResultOrProblems.of((Object)new ClassifierFunction(parsed, project));
    }

    public Object call(List<Object> args) {
        throw new UnsupportedOperationException();
    }

    public ResultOrProblems<IdentifiedFunction> identified(Resource resource) {
        if (!this.ast.id.isPresent()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.MISSING_ID, (Object[])new Object[0])});
        }
        String id = this.ast.id.get().value();
        IdentifiedFunction.Category category = IdentifiedFunction.Category.UNASSIGNED;
        if (this.ast.category.isPresent()) {
            String declared = this.ast.category.get().value();
            try {
                category = IdentifiedFunction.Category.valueOf((String)declared.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.notAnOption((String)declared, IdentifiedFunction.Category.class)});
            }
        }
        return ResultOrProblems.of((Object)this.identified(id, this.ast.description.map(AST.Metadata::value).orElse(null), resource.getLocation(), category));
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        if (argumentTypes.size() > 0) {
            ArrayList<Problem> argProblems = new ArrayList<Problem>(argumentTypes.size());
            TypeSet typeSet = context.getProject().getTypeSet();
            for (int i = 0; i < this.getArguments().size(); ++i) {
                FunctionArgument arg = this.getArguments().get(i);
                Type requiredType = arg.getType();
                Type givenType = argumentTypes.get(i);
                if (typeSet.isAssignable(givenType, requiredType)) continue;
                argProblems.add(ArgsProblems.mismatch((FunctionArgument)arg, (Type)givenType));
            }
            if (!argProblems.isEmpty()) {
                return ResultOrProblems.failed(argProblems);
            }
        }
        ExpressionParser exprParser = new ExpressionParser();
        DefaultTypeBuilder builder = new DefaultTypeBuilder(this.project.getTypeSet());
        ExpressionRealizer realizer = context.getExpressionRealizer();
        ArrayList<Problem> all = new ArrayList<Problem>();
        all.addAll(this.ast.parseExpressions(exprParser));
        all.addAll(this.ast.parseTypes((TypeBuilder)builder));
        if (Problem.hasErrors(all)) {
            return ResultOrProblems.failed(all);
        }
        Compiled compiled = new Compiled();
        compiled.typeSet = context.getTypeSet();
        compiled.argumentsStructType = this.ast.argumentTypesDecl.built;
        if (argumentTypes.size() > 0) {
            Struct asBuilt = this.ast.argumentTypesDecl.built;
            Struct.StructBuilder actual = Struct.builder();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Struct.StructMember m = (Struct.StructMember)asBuilt.getMembers().get(i);
                actual.add(m.getKey(), argumentTypes.get(i));
            }
            compiled.argumentsStructType = actual.build();
        }
        if (this.ast.pre.isPresent()) {
            ResultOrProblems preExprOr = RealizedTreeExpression.build(realizer, this.ast.pre.get(), (Type)compiled.argumentsStructType).map(rExpr -> {
                compiled.pre = rExpr;
                return compiled.pre;
            });
            if (preExprOr.hasErrors()) {
                return preExprOr.composeFailure(Problems.foundWith((Object)this.ast.pre.get().getIdentifier(), (Problem[])new Problem[0]));
            }
            compiled.pre = (RealizedTreeExpression)preExprOr.get();
        }
        if (compiled.bodyInputType().hasErrors()) {
            return ResultOrProblems.failed((List)compiled.bodyInputType().getProblems());
        }
        ResultOrProblems<RealizedTreeFilter> filterOr = RealizedTreeFilter.build(realizer, this.ast, (Type)compiled.bodyInputType().get());
        if (filterOr.hasErrors()) {
            return ResultOrProblems.failed((List)filterOr.getProblems());
        }
        ResultOrProblems<ReturnTypeInferer> bodyAdaptor = ReturnTypeInferer.build((RealizedTreeFilter)filterOr.get(), context.getProject().getTypeSet());
        if (bodyAdaptor.hasErrors()) {
            return ResultOrProblems.failed((List)bodyAdaptor.getProblems());
        }
        compiled.body = (ReturnTypeInferer)bodyAdaptor.get();
        compiled.bodyType = ((ReturnTypeInferer)bodyAdaptor.get()).getResultType();
        if (this.ast.post.isPresent()) {
            if (compiled.postInputType().hasErrors()) {
                return ResultOrProblems.failed((List)compiled.postInputType().getProblems());
            }
            ResultOrProblems<RealizedTreeExpression> postExprOr = RealizedTreeExpression.build(realizer, this.ast.post.get(), (Type)compiled.postInputType().get());
            if (postExprOr.hasErrors()) {
                return ResultOrProblems.failed((List)postExprOr.getProblems());
            }
            compiled.post = (RealizedTreeExpression)postExprOr.get();
        }
        compiled.declaredReturnType = this.ast.returnTypeDecl.map(rtd -> rtd.getBuilt()).orElse(null);
        return this.checkReturnType(compiled);
    }

    private ResultOrProblems<RiskscapeFunction> checkReturnType(Compiled compiled) {
        Type declared = compiled.declaredReturnType;
        Type inferred = compiled.inferredReturnType();
        if (declared == null) {
            return ResultOrProblems.of((Object)new Realized(compiled));
        }
        return new ReturnTypeCheck(inferred, declared).check(compiled);
    }

    public Type getReturnType() {
        this.ast.returnTypeDecl.ifPresent(td -> td.build(new ArrayList<Problem>(), this.project.getTypeBuilder()));
        return (Type)this.ast.returnTypeDecl.flatMap(decl -> Optional.ofNullable(decl.getBuilt())).orElse(Types.ANYTHING);
    }

    public ArgumentList getArguments() {
        if (this.arguments == null) {
            TypeBuilder builder = this.project.getTypeBuilder();
            ArrayList<Problem> problems = new ArrayList<Problem>();
            ArrayList<FunctionArgument> args = new ArrayList<FunctionArgument>(this.ast.argumentTypesDecl.children.size());
            for (AST.TypeDecl decl : this.ast.argumentTypesDecl.children) {
                decl.build(problems, builder);
                Object type = decl.getBuilt() != null ? decl.getBuilt() : Types.ANYTHING;
                args.add(new FunctionArgument(decl.getIdentifier().value, (Type)type));
            }
            this.arguments = new ArgumentList(args);
        }
        return this.arguments;
    }

    public List<Type> getArgumentTypes() {
        return this.getArguments().getArgumentTypes();
    }

    public ResultOrProblems<Boolean> validate(RealizationContext context) {
        ArrayList problems = new ArrayList();
        if (this.ast.returnTypeDecl.isPresent()) {
            this.validateTypeExists(this.ast.returnTypeDecl.get().getBuilt(), p -> problems.add(p));
        }
        for (Type argumentType : this.getArgumentTypes()) {
            this.validateTypeExists(argumentType, p -> problems.add(p));
        }
        if (!problems.isEmpty()) {
            return ResultOrProblems.failed(problems);
        }
        return this.realize(context, null, Collections.emptyList()).map(f -> true);
    }

    private void validateTypeExists(Type type, Consumer<Problem> problems) {
        if (type instanceof IdentifiedType) {
            IdentifiedType identified = (IdentifiedType)type;
            try {
                identified.getUnderlyingType();
            }
            catch (MissingTypeException e) {
                problems.accept(e.getProblem());
            }
        }
    }

    public String toString() {
        return String.format("Classifier[args=%s, return-type=%s]", this.getArguments(), this.getReturnType());
    }

    @Generated
    public ClassifierFunction(AST.FunctionDecl ast, Project project) {
        this.ast = ast;
        this.project = project;
    }

    @Generated
    public AST.FunctionDecl getAst() {
        return this.ast;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    private static class Compiled {
        public Struct argumentsStructType;
        public RealizedTreeExpression pre;
        public ReturnTypeInferer body;
        public RealizedTreeExpression post;
        public Type bodyType;
        public Type declaredReturnType;
        private Struct bodyInputType;
        private Struct postInputType;
        private TypeSet typeSet;

        private Compiled() {
        }

        public ResultOrProblems<Struct> bodyInputType() {
            if (this.bodyInputType == null) {
                if (this.pre == null) {
                    this.bodyInputType = this.argumentsStructType;
                } else {
                    Type preType = this.pre.getResultType();
                    if (preType instanceof Struct) {
                        Struct preStruct = (Struct)preType;
                        this.bodyInputType = this.argumentsStructType.and(preStruct);
                    } else {
                        return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.PRE_NOT_STRUCT, (Object[])new Object[]{preType})});
                    }
                }
            }
            return ResultOrProblems.of((Object)this.bodyInputType);
        }

        public ResultOrProblems<Struct> postInputType() {
            if (this.postInputType == null) {
                if (!this.bodyType.findAllowNull(Struct.class).isPresent()) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.BODY_NOT_STRUCT, (Object[])new Object[]{this.bodyType})});
                }
                ResultOrProblems bit = this.bodyInputType().map(bis -> bis.and(this.bodyType.asStruct()));
                if (bit.hasErrors()) {
                    return bit;
                }
                this.postInputType = (Struct)bit.get();
            }
            return ResultOrProblems.of((Object)this.postInputType);
        }

        public Type inferredReturnType() {
            Type returnType = this.post == null ? (this.body.isDefaultPresent() ? this.bodyType : Nullable.of((Type)this.bodyType)) : this.post.getResultType();
            if (returnType.findAllowNull(Struct.class).isPresent()) {
                return this.inferredReturnTypeAllAttributes();
            }
            return returnType;
        }

        private Type inferredReturnTypeAllAttributes() {
            if (this.pre == null && this.post == null) {
                return this.bodyType;
            }
            Struct produced = this.pre != null ? this.pre.getResultType().asStruct() : null;
            produced = this.mergeToReturnType((Type)produced, (Type)this.bodyType.asStruct());
            if (this.post != null) {
                produced = this.mergeToReturnType((Type)produced, (Type)this.post.getResultType().asStruct());
            }
            return produced;
        }

        private Type mergeToReturnType(Type soFar, Type toAdd) {
            if (soFar == null) {
                return toAdd;
            }
            boolean nullSoFar = Nullable.is((Type)soFar);
            Struct soFarStruct = (Struct)soFar.findAllowNull(Struct.class).get();
            boolean nullableToAdd = Nullable.is((Type)toAdd);
            Struct toAddStruct = (Struct)toAdd.findAllowNull(Struct.class).get();
            boolean addNullableEntries = nullableToAdd && !nullSoFar;
            for (Struct.StructMember member : toAddStruct.getMembers()) {
                Type toAddMemberType = Nullable.ifTrue((boolean)addNullableEntries, (Type)member.getType());
                if (!soFarStruct.hasMember(member.getKey())) {
                    soFarStruct = soFarStruct.and(member.getKey(), toAddMemberType);
                    continue;
                }
                if (toAddMemberType.equals(soFarStruct.getEntry(member.getKey()).getType())) continue;
                Type common = this.typeSet.computeAncestorNoConversion(toAddMemberType, soFarStruct.getEntry(member.getKey()).getType());
                soFarStruct = soFarStruct.replace(member.getKey(), common);
            }
            return Nullable.ifTrue((nullSoFar && nullableToAdd ? 1 : 0) != 0, (Type)soFarStruct);
        }
    }

    private class Realized
    implements RiskscapeFunction {
        private final Compiled typeInfo;
        private final ArgumentList arguments;
        private final List<Type> argumentTypes;
        private final Type returnType;
        private final Type inferredReturnType;
        private final boolean combineAll;
        private final boolean coerceRequired;

        Realized(Compiled typeInfo) {
            this.typeInfo = typeInfo;
            this.arguments = ArgumentList.fromStruct((Struct)typeInfo.argumentsStructType);
            this.argumentTypes = this.getTypesFromArguments();
            this.coerceRequired = typeInfo.declaredReturnType != null;
            this.inferredReturnType = typeInfo.inferredReturnType();
            this.returnType = Nullable.ifTrue((boolean)Nullable.is((Type)this.inferredReturnType), (Type)(typeInfo.declaredReturnType != null ? typeInfo.declaredReturnType : this.inferredReturnType));
            this.combineAll = this.inferredReturnType.findAllowNull(Struct.class).isPresent();
        }

        public Object call(List<Object> args) {
            Object toReturn;
            Object resultTuple = null;
            Object input = Tuple.ofValues((Struct)this.typeInfo.argumentsStructType, (Object[])args.toArray());
            Object lastResult = input;
            if (this.typeInfo.pre != null) {
                lastResult = this.typeInfo.pre.evaluate(input);
                if (!this.typeInfo.pre.resultType.internalType().isInstance(lastResult)) {
                    throw new RiskscapeException(String.format("Unexpected java type returned from %s pre.  Was %s, expected %s", this, lastResult == null ? null : lastResult.getClass(), this.typeInfo.pre.resultType.internalType()));
                }
                Object preResult = lastResult;
                Tuple newTuple = new Tuple((Struct)this.typeInfo.bodyInputType().get());
                newTuple.setAll(input);
                newTuple.setAll(input.size(), (Tuple)preResult);
                input = newTuple;
                if (this.combineAll) {
                    resultTuple = Tuple.of((Struct)Nullable.strip((Type)this.inferredReturnType).asStruct());
                    resultTuple.setAll((Tuple)preResult);
                }
            }
            if ((lastResult = this.typeInfo.body.evaluate(input)) instanceof Tuple) {
                Tuple last = Tuple.coerce((Struct)((Struct)this.typeInfo.bodyType.findAllowNull(Struct.class).get()), (Map)lastResult.toMap(), EnumSet.of(Tuple.CoerceOptions.MISSING_IGNORED));
                if (this.combineAll) {
                    if (resultTuple == null) {
                        resultTuple = Tuple.of((Struct)Nullable.strip((Type)this.inferredReturnType).asStruct());
                    }
                    for (Struct.StructMember member : last.getStruct().getMembers()) {
                        Object o = last.fetch(member);
                        if (o == null) continue;
                        resultTuple.set(member.getKey(), o);
                    }
                }
                lastResult = last;
            }
            if (lastResult == null) {
                if (!Nullable.is((Type)this.typeInfo.bodyType) && this.typeInfo.body.isDefaultPresent()) {
                    throw new RiskscapeException(String.format("Unexpected null returned from %s body.  Expected %s", this, this.typeInfo.bodyType.internalType()));
                }
            } else if (!this.typeInfo.bodyType.internalType().isInstance(lastResult)) {
                throw new RiskscapeException(String.format("Unexpected java type returned from %s body.  Was %s, expected %s", this, lastResult == null ? null : lastResult.getClass(), this.typeInfo.bodyType.internalType()));
            }
            if (this.typeInfo.post != null) {
                Struct bodyType = (Struct)this.typeInfo.bodyType.findAllowNull(Struct.class).get();
                Tuple lastTuple = (Tuple)lastResult;
                Object[] newValues = new Object[input.size() + bodyType.size()];
                System.arraycopy(input.toArray(), 0, newValues, 0, input.size());
                if (lastTuple != null) {
                    System.arraycopy(lastTuple.toArray(), 0, newValues, input.size(), lastTuple.size());
                }
                input = Tuple.ofValues((Struct)((Struct)this.typeInfo.postInputType().get()), (Object[])newValues);
                lastResult = this.typeInfo.post.evaluate(input);
                if (!this.typeInfo.post.resultType.internalType().isInstance(lastResult)) {
                    throw new RiskscapeException(String.format("Unexpected java type returned from %s post.  Was %s, expected %s", this, lastResult == null ? null : lastResult.getClass(), this.typeInfo.post.resultType.internalType()));
                }
                if (this.combineAll) {
                    if (resultTuple == null) {
                        resultTuple = Tuple.of((Struct)Nullable.strip((Type)this.inferredReturnType).asStruct());
                    }
                    Tuple last = (Tuple)lastResult;
                    for (Struct.StructMember member : last.getStruct().getMembers()) {
                        resultTuple.set(member.getKey(), last.fetch(member));
                    }
                }
            }
            Object object = toReturn = this.combineAll ? resultTuple : lastResult;
            if (this.coerceRequired) {
                return this.returnType.coerce(toReturn);
            }
            return toReturn;
        }

        @Generated
        public ArgumentList getArguments() {
            return this.arguments;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public Type getReturnType() {
            return this.returnType;
        }
    }

    class ReturnTypeCheck {
        private Type deNulledDeclared;
        private Struct declaredStruct;
        private Type deNulledInferredType;
        private Struct inferredStruct;
        private Type inferred;
        private Type declared;
        private final AST.TypeDecl returnTypeDecl;

        ReturnTypeCheck(Type inferred, Type declared) {
            this.declared = declared;
            this.deNulledDeclared = Nullable.unwrap((Type)declared);
            this.declaredStruct = this.deNulledDeclared.find(Struct.class).orElse(null);
            this.inferred = inferred;
            this.deNulledInferredType = Nullable.unwrap((Type)inferred);
            this.inferredStruct = this.deNulledInferredType.find(Struct.class).orElse(null);
            this.returnTypeDecl = ClassifierFunction.this.ast.returnTypeDecl.get();
        }

        public ResultOrProblems<RiskscapeFunction> check(Compiled compiled) {
            if (this.inferredStruct == null && this.declaredStruct != null && this.declaredStruct.getMembers().size() == 1) {
                this.inferredStruct = Struct.of((String)((String)this.declaredStruct.getMemberKeys().get(0)), (Type)this.deNulledInferredType);
            }
            if (this.inferredStruct == null ^ this.declaredStruct == null) {
                return ResultOrProblems.failed((Problem[])new Problem[]{((TypeProblems)Problems.get(TypeProblems.class)).mismatch((Object)this.returnTypeDecl.getIdentifier(), this.declared, this.inferred)});
            }
            if (this.inferredStruct == null) {
                Type declaredUnwrapped;
                Type inferredUnwrapped = this.deNulledInferredType.getUnwrappedType();
                if (!inferredUnwrapped.equals(declaredUnwrapped = this.deNulledDeclared.getUnwrappedType())) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{((TypeProblems)Problems.get(TypeProblems.class)).mismatch((Object)this.returnTypeDecl.getIdentifier(), inferredUnwrapped, declaredUnwrapped)});
                }
                return ResultOrProblems.of((Object)new Realized(compiled));
            }
            return this.checkStructReturnType(compiled).composeProblems((s, l) -> Problems.foundWith((Object)this.returnTypeDecl.getIdentifier(), (List)l));
        }

        private ResultOrProblems<RiskscapeFunction> returnTypeMismatch(Problem problem) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.RETURN_TYPE_MISMATCH, (Object[])new Object[0]).withChildren(new Problems[]{problem})});
        }

        private ResultOrProblems<RiskscapeFunction> checkStructReturnType(Compiled compiled) {
            for (Struct.StructMember declaredMember : this.declaredStruct.getMembers()) {
                Type unwrappedInferredMemberType;
                Struct.StructMember inferredMember = this.inferredStruct.getMember(declaredMember.getKey()).orElse(null);
                if (inferredMember == null) {
                    if (Nullable.is((Type)declaredMember.getType())) continue;
                    return this.returnTypeMismatch(((TypeProblems)Problems.get(TypeProblems.class)).structMemberNotProvided(declaredMember, this.inferredStruct));
                }
                if (Nullable.is((Type)inferredMember.getType()) && !Nullable.is((Type)declaredMember.getType())) {
                    return this.returnTypeMismatch(((TypeProblems)Problems.get(TypeProblems.class)).mismatch((Object)declaredMember, declaredMember.getType(), inferredMember.getType()));
                }
                Type unwrappedDeclaredMemberType = Nullable.unwrap((Type)declaredMember.getType());
                if (unwrappedDeclaredMemberType.equals(unwrappedInferredMemberType = Nullable.unwrap((Type)inferredMember.getType()))) continue;
                return this.returnTypeMismatch(((TypeProblems)Problems.get(TypeProblems.class)).mismatch((Object)declaredMember, unwrappedDeclaredMemberType, unwrappedInferredMemberType));
            }
            return ResultOrProblems.of((Object)new Realized(compiled));
        }
    }
}

