/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.classifier;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.defaults.classifier.TokenTypes;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typexp.TypeBuilder;
import nz.org.riskscape.engine.typexp.TypeBuildingException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;

public abstract class AST {
    public abstract Token getBoundaryToken();

    public Token getIdentifier() {
        return this.getBoundaryToken();
    }

    public static class StructExpression
    extends AST
    implements ExpressionDecl {
        public final Token identifier;
        public final List<ExpressionDecl> members;

        public static StructExpression create(String ident, SimpleExpression ... children) {
            return new StructExpression(Token.token((TokenType)TokenTypes.IDENTIFIER, (String)ident), Arrays.asList(children));
        }

        public Optional<ExpressionDecl> find(String memberName) {
            for (ExpressionDecl typeDecl : this.members) {
                if (!typeDecl.getIdentifier().value.equals(memberName)) continue;
                return Optional.of(typeDecl);
            }
            return Optional.empty();
        }

        @Override
        public Set<String> scanStructKeys() {
            HashSet<String> childKeys = new HashSet<String>();
            for (ExpressionDecl expressionDecl : this.members) {
                childKeys.addAll(expressionDecl.scanStructKeys());
            }
            return childKeys;
        }

        @Override
        public void build(List<Problem> problems, ExpressionParser parser) {
            for (ExpressionDecl expression : this.members) {
                expression.build(problems, parser);
            }
        }

        @Override
        public Token getBoundaryToken() {
            return this.identifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructExpression)) {
                return false;
            }
            StructExpression other = (StructExpression)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$identifier = this.getIdentifier();
            Token other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            List<ExpressionDecl> this$members = this.members;
            List<ExpressionDecl> other$members = other.members;
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StructExpression;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            List<ExpressionDecl> $members = this.members;
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.StructExpression(identifier=" + String.valueOf(this.getIdentifier()) + ", members=" + String.valueOf(this.members) + ")";
        }

        @Generated
        public StructExpression(Token identifier, List<ExpressionDecl> members) {
            this.identifier = identifier;
            this.members = members;
        }

        @Override
        @Generated
        public Token getIdentifier() {
            return this.identifier;
        }
    }

    public static class SimpleExpression
    extends AST
    implements ExpressionDecl {
        public final Token identifier;
        public final List<Token> expressionParts;
        public final String expression;
        public Expression built;

        public static SimpleExpression create(String ident, Expression expr) {
            SimpleExpression instance = new SimpleExpression(Token.token((TokenType)TokenTypes.IDENTIFIER, (String)ident), Lists.newArrayList((Object[])new Token[]{Token.token((TokenType)TokenTypes.EXPRESSION, (String)expr.toSource())}));
            instance.built = expr;
            return instance;
        }

        public SimpleExpression(Token identifier, Token exprToken) {
            this(identifier, Lists.newArrayList((Object[])new Token[]{exprToken}));
        }

        public SimpleExpression(Token identifier, List<Token> expressionParts) {
            this.identifier = identifier;
            this.expressionParts = expressionParts;
            this.expression = expressionParts.stream().map(Token::rawValue).collect(Collectors.joining());
        }

        @Override
        public void build(List<Problem> problems, ExpressionParser parser) {
            try {
                this.built = parser.parse(this.expression);
            }
            catch (LexerException | ParseException ex) {
                Problem exprProblem = Problems.foundWith(Expression.class, (String)this.expression, (Problem[])new Problem[]{Problems.caught((Throwable)ex)});
                problems.add(Problems.foundWith((Object)this.getIdentifier(), (Problems)exprProblem));
            }
        }

        @Override
        public Set<String> scanStructKeys() {
            return Collections.singleton(this.identifier.value);
        }

        @Override
        public Token getBoundaryToken() {
            return this.identifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleExpression)) {
                return false;
            }
            SimpleExpression other = (SimpleExpression)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$identifier = this.getIdentifier();
            Token other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            List<Token> this$expressionParts = this.getExpressionParts();
            List<Token> other$expressionParts = other.getExpressionParts();
            if (this$expressionParts == null ? other$expressionParts != null : !((Object)this$expressionParts).equals(other$expressionParts)) {
                return false;
            }
            String this$expression = this.getExpression();
            String other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            Expression this$built = this.built;
            Expression other$built = other.built;
            return !(this$built == null ? other$built != null : !this$built.equals(other$built));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleExpression;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            List<Token> $expressionParts = this.getExpressionParts();
            result = result * 59 + ($expressionParts == null ? 43 : ((Object)$expressionParts).hashCode());
            String $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            Expression $built = this.built;
            result = result * 59 + ($built == null ? 43 : $built.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.SimpleExpression(identifier=" + String.valueOf(this.getIdentifier()) + ", expressionParts=" + String.valueOf(this.getExpressionParts()) + ", expression=" + this.getExpression() + ", built=" + String.valueOf(this.built) + ")";
        }

        @Generated
        public SimpleExpression(Token identifier, List<Token> expressionParts, String expression) {
            this.identifier = identifier;
            this.expressionParts = expressionParts;
            this.expression = expression;
        }

        @Override
        @Generated
        public Token getIdentifier() {
            return this.identifier;
        }

        @Generated
        public List<Token> getExpressionParts() {
            return this.expressionParts;
        }

        @Generated
        public String getExpression() {
            return this.expression;
        }
    }

    public static interface ExpressionDecl {
        public Token getIdentifier();

        public Set<String> scanStructKeys();

        public void build(List<Problem> var1, ExpressionParser var2);
    }

    public static class Filter
    extends AST {
        public final Token identifier;
        public final Token filterExpression;
        public final List<Filter> children;
        public final Optional<ExpressionDecl> orElse;
        public Expression built;

        public void build(List<Problem> problems, ExpressionParser parser) {
            SimpleExpression simple = new SimpleExpression(this.identifier, this.filterExpression);
            simple.build(problems, parser);
            this.built = simple.built;
            this.orElse.ifPresent(expr -> expr.build(problems, parser));
            for (Filter filter : this.children) {
                filter.build(problems, parser);
            }
        }

        public Set<String> scanStructKeys() {
            LinkedHashSet<String> collected = new LinkedHashSet<String>();
            this.orElse.ifPresent(o -> collected.addAll(o.scanStructKeys()));
            for (Filter filter : this.children) {
                collected.addAll(filter.scanStructKeys());
            }
            return collected;
        }

        @Override
        public Token getBoundaryToken() {
            return this.identifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$identifier = this.getIdentifier();
            Token other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Token this$filterExpression = this.filterExpression;
            Token other$filterExpression = other.filterExpression;
            if (this$filterExpression == null ? other$filterExpression != null : !this$filterExpression.equals(other$filterExpression)) {
                return false;
            }
            List<Filter> this$children = this.children;
            List<Filter> other$children = other.children;
            if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
                return false;
            }
            Optional<ExpressionDecl> this$orElse = this.orElse;
            Optional<ExpressionDecl> other$orElse = other.orElse;
            if (this$orElse == null ? other$orElse != null : !((Object)this$orElse).equals(other$orElse)) {
                return false;
            }
            Expression this$built = this.built;
            Expression other$built = other.built;
            return !(this$built == null ? other$built != null : !this$built.equals(other$built));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Filter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Token $filterExpression = this.filterExpression;
            result = result * 59 + ($filterExpression == null ? 43 : $filterExpression.hashCode());
            List<Filter> $children = this.children;
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            Optional<ExpressionDecl> $orElse = this.orElse;
            result = result * 59 + ($orElse == null ? 43 : ((Object)$orElse).hashCode());
            Expression $built = this.built;
            result = result * 59 + ($built == null ? 43 : $built.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.Filter(identifier=" + String.valueOf(this.getIdentifier()) + ", filterExpression=" + String.valueOf(this.filterExpression) + ", children=" + String.valueOf(this.children) + ", orElse=" + String.valueOf(this.orElse) + ", built=" + String.valueOf(this.built) + ")";
        }

        @Generated
        public Filter(Token identifier, Token filterExpression, List<Filter> children, Optional<ExpressionDecl> orElse) {
            this.identifier = identifier;
            this.filterExpression = filterExpression;
            this.children = children;
            this.orElse = orElse;
        }

        @Override
        @Generated
        public Token getIdentifier() {
            return this.identifier;
        }
    }

    public static class StructType
    extends AST
    implements TypeDecl {
        public final Token identifier;
        public final List<TypeDecl> children;
        public Struct built;

        public Optional<TypeDecl> find(String memberName) {
            for (TypeDecl typeDecl : this.children) {
                if (!typeDecl.getIdentifier().value.equals(memberName)) continue;
                return Optional.of(typeDecl);
            }
            return Optional.empty();
        }

        @Override
        public void build(List<Problem> problems, TypeBuilder builder) {
            Struct.StructBuilder structBuilder = new Struct.StructBuilder(this.children.size());
            for (TypeDecl typeDecl : this.children) {
                typeDecl.build(problems, builder);
                if (typeDecl.getBuilt() == null) continue;
                structBuilder.add(typeDecl.getIdentifier().value, typeDecl.getBuilt());
            }
            ResultOrProblems builtOr = structBuilder.buildOr();
            if (builtOr.hasProblems()) {
                problems.add(Problem.composite((List)builtOr.getProblems(), (String)"Failed to build type for %s", (Object[])new Object[]{this.identifier}));
            } else {
                this.built = (Struct)builtOr.get();
            }
        }

        @Override
        public Token getBoundaryToken() {
            return this.identifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructType)) {
                return false;
            }
            StructType other = (StructType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$identifier = this.getIdentifier();
            Token other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            List<TypeDecl> this$children = this.children;
            List<TypeDecl> other$children = other.children;
            if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
                return false;
            }
            Struct this$built = this.getBuilt();
            Struct other$built = other.getBuilt();
            return !(this$built == null ? other$built != null : !this$built.equals(other$built));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StructType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            List<TypeDecl> $children = this.children;
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            Struct $built = this.getBuilt();
            result = result * 59 + ($built == null ? 43 : $built.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.StructType(identifier=" + String.valueOf(this.getIdentifier()) + ", children=" + String.valueOf(this.children) + ", built=" + String.valueOf(this.getBuilt()) + ")";
        }

        @Generated
        public StructType(Token identifier, List<TypeDecl> children) {
            this.identifier = identifier;
            this.children = children;
        }

        @Override
        @Generated
        public Token getIdentifier() {
            return this.identifier;
        }

        @Generated
        public Struct getBuilt() {
            return this.built;
        }
    }

    public static class SimpleType
    extends AST
    implements TypeDecl {
        public final Token identifier;
        public final Token expression;
        public Type built;

        @Override
        public void build(List<Problem> problems, TypeBuilder builder) {
            try {
                this.built = builder.build(this.expression.value);
            }
            catch (MissingTypeException | TypeBuildingException ex) {
                problems.add(Problems.foundWith((Object)this.getIdentifier(), (Problems)ExpressionProblems.cannotParse(Type.class, (String)this.expression.value).withChildren(new Problems[]{Problems.caught((Throwable)ex)})));
            }
        }

        @Override
        public Token getBoundaryToken() {
            return this.identifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleType)) {
                return false;
            }
            SimpleType other = (SimpleType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$identifier = this.getIdentifier();
            Token other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Token this$expression = this.getExpression();
            Token other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            Type this$built = this.getBuilt();
            Type other$built = other.getBuilt();
            return !(this$built == null ? other$built != null : !this$built.equals(other$built));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Token $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            Type $built = this.getBuilt();
            result = result * 59 + ($built == null ? 43 : $built.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.SimpleType(identifier=" + String.valueOf(this.getIdentifier()) + ", expression=" + String.valueOf(this.getExpression()) + ", built=" + String.valueOf(this.getBuilt()) + ")";
        }

        @Generated
        public SimpleType(Token identifier, Token expression) {
            this.identifier = identifier;
            this.expression = expression;
        }

        @Override
        @Generated
        public Token getIdentifier() {
            return this.identifier;
        }

        @Generated
        public Token getExpression() {
            return this.expression;
        }

        @Override
        @Generated
        public Type getBuilt() {
            return this.built;
        }
    }

    static interface TypeDecl {
        public Token getIdentifier();

        public Type getBuilt();

        public void build(List<Problem> var1, TypeBuilder var2);
    }

    public static class Metadata
    extends AST {
        public final Token identifier;
        public final Token value;

        public String value() {
            return this.value.value;
        }

        @Override
        public Token getBoundaryToken() {
            return this.identifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$identifier = this.identifier;
            Token other$identifier = other.identifier;
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Token this$value = this.value;
            Token other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $identifier = this.identifier;
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Token $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.Metadata(identifier=" + String.valueOf(this.identifier) + ", value=" + String.valueOf(this.value) + ")";
        }

        @Generated
        public Metadata(Token identifier, Token value) {
            this.identifier = identifier;
            this.value = value;
        }
    }

    public static class FunctionDecl
    extends AST {
        public final Token start;
        public final Optional<Metadata> id;
        public final Optional<Metadata> description;
        public final Optional<Metadata> category;
        public final StructType argumentTypesDecl;
        public final Optional<TypeDecl> returnTypeDecl;
        public final Optional<ExpressionDecl> pre;
        public final List<Filter> body;
        public final Optional<ExpressionDecl> defaultExpr;
        public final Optional<ExpressionDecl> post;

        public List<Problem> parseTypes(TypeBuilder builder) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            this.returnTypeDecl.ifPresent(rtd -> rtd.build(problems, builder));
            this.argumentTypesDecl.build(problems, builder);
            return problems;
        }

        public List<Problem> parseExpressions(ExpressionParser parser) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            this.pre.ifPresent(expr -> expr.build(problems, parser));
            this.post.ifPresent(expr -> expr.build(problems, parser));
            this.defaultExpr.ifPresent(expr -> expr.build(problems, parser));
            this.body.stream().forEach(filter -> filter.build(problems, parser));
            return problems;
        }

        public Set<String> scanStructKeys() {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            this.pre.ifPresent(p -> keys.addAll(p.scanStructKeys()));
            this.post.ifPresent(p -> keys.addAll(p.scanStructKeys()));
            this.defaultExpr.ifPresent(p -> keys.addAll(p.scanStructKeys()));
            this.body.stream().forEach(b -> keys.addAll(b.scanStructKeys()));
            return keys;
        }

        public Struct getInputType() {
            return this.argumentTypesDecl.built;
        }

        @Override
        public Token getBoundaryToken() {
            return this.start;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionDecl)) {
                return false;
            }
            FunctionDecl other = (FunctionDecl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Token this$start = this.start;
            Token other$start = other.start;
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            Optional<Metadata> this$id = this.id;
            Optional<Metadata> other$id = other.id;
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Optional<Metadata> this$description = this.description;
            Optional<Metadata> other$description = other.description;
            if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
                return false;
            }
            Optional<Metadata> this$category = this.category;
            Optional<Metadata> other$category = other.category;
            if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
                return false;
            }
            StructType this$argumentTypesDecl = this.getArgumentTypesDecl();
            StructType other$argumentTypesDecl = other.getArgumentTypesDecl();
            if (this$argumentTypesDecl == null ? other$argumentTypesDecl != null : !((Object)this$argumentTypesDecl).equals(other$argumentTypesDecl)) {
                return false;
            }
            Optional<TypeDecl> this$returnTypeDecl = this.returnTypeDecl;
            Optional<TypeDecl> other$returnTypeDecl = other.returnTypeDecl;
            if (this$returnTypeDecl == null ? other$returnTypeDecl != null : !((Object)this$returnTypeDecl).equals(other$returnTypeDecl)) {
                return false;
            }
            Optional<ExpressionDecl> this$pre = this.pre;
            Optional<ExpressionDecl> other$pre = other.pre;
            if (this$pre == null ? other$pre != null : !((Object)this$pre).equals(other$pre)) {
                return false;
            }
            List<Filter> this$body = this.body;
            List<Filter> other$body = other.body;
            if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
                return false;
            }
            Optional<ExpressionDecl> this$defaultExpr = this.defaultExpr;
            Optional<ExpressionDecl> other$defaultExpr = other.defaultExpr;
            if (this$defaultExpr == null ? other$defaultExpr != null : !((Object)this$defaultExpr).equals(other$defaultExpr)) {
                return false;
            }
            Optional<ExpressionDecl> this$post = this.post;
            Optional<ExpressionDecl> other$post = other.post;
            return !(this$post == null ? other$post != null : !((Object)this$post).equals(other$post));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionDecl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Token $start = this.start;
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            Optional<Metadata> $id = this.id;
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Optional<Metadata> $description = this.description;
            result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
            Optional<Metadata> $category = this.category;
            result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
            StructType $argumentTypesDecl = this.getArgumentTypesDecl();
            result = result * 59 + ($argumentTypesDecl == null ? 43 : ((Object)$argumentTypesDecl).hashCode());
            Optional<TypeDecl> $returnTypeDecl = this.returnTypeDecl;
            result = result * 59 + ($returnTypeDecl == null ? 43 : ((Object)$returnTypeDecl).hashCode());
            Optional<ExpressionDecl> $pre = this.pre;
            result = result * 59 + ($pre == null ? 43 : ((Object)$pre).hashCode());
            List<Filter> $body = this.body;
            result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
            Optional<ExpressionDecl> $defaultExpr = this.defaultExpr;
            result = result * 59 + ($defaultExpr == null ? 43 : ((Object)$defaultExpr).hashCode());
            Optional<ExpressionDecl> $post = this.post;
            result = result * 59 + ($post == null ? 43 : ((Object)$post).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AST.FunctionDecl(start=" + String.valueOf(this.start) + ", id=" + String.valueOf(this.id) + ", description=" + String.valueOf(this.description) + ", category=" + String.valueOf(this.category) + ", argumentTypesDecl=" + String.valueOf(this.getArgumentTypesDecl()) + ", returnTypeDecl=" + String.valueOf(this.returnTypeDecl) + ", pre=" + String.valueOf(this.pre) + ", body=" + String.valueOf(this.body) + ", defaultExpr=" + String.valueOf(this.defaultExpr) + ", post=" + String.valueOf(this.post) + ")";
        }

        @Generated
        public FunctionDecl(Token start, Optional<Metadata> id, Optional<Metadata> description, Optional<Metadata> category, StructType argumentTypesDecl, Optional<TypeDecl> returnTypeDecl, Optional<ExpressionDecl> pre, List<Filter> body, Optional<ExpressionDecl> defaultExpr, Optional<ExpressionDecl> post) {
            this.start = start;
            this.id = id;
            this.description = description;
            this.category = category;
            this.argumentTypesDecl = argumentTypesDecl;
            this.returnTypeDecl = returnTypeDecl;
            this.pre = pre;
            this.body = body;
            this.defaultExpr = defaultExpr;
            this.post = post;
        }

        @Generated
        public StructType getArgumentTypesDecl() {
            return this.argumentTypesDecl;
        }
    }
}

