/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.auth;

import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.auth.HttpSecret;
import nz.org.riskscape.engine.auth.Secret;
import nz.org.riskscape.engine.auth.SecretBuilder;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.problem.ResultOrProblems;

public class KoordinatesKeySecret
extends HttpSecret {
    public static final String FRAMEWORK_NAME = "koordinates";
    public static final JavaParameterSet<KoordinatesKeySecret> PARAMETER_SET = JavaParameterSet.fromBindingClass(KoordinatesKeySecret.class);
    public static final SecretBuilder BUILDER = new SecretBuilder("koordinates", KoordinatesKeySecret.class, PARAMETER_SET, bound -> ResultOrProblems.of((Object)((Secret)PARAMETER_SET.bindToObject(bound).getBoundToObject())));
    @ParameterField
    private String apiKey;

    public KoordinatesKeySecret() {
        super(FRAMEWORK_NAME);
    }

    public boolean matches(URI uri) {
        return super.matches(uri) && this.isPathAServicesRequest(uri.getPath());
    }

    public void apply(HttpSecret.Request request) {
        if (this.isPathAServicesRequest(request.getPath())) {
            String[] pathComponents = request.getPath().substring(1).split("/");
            String servicesPart = pathComponents[0];
            pathComponents[0] = String.format("%s;key=%s", servicesPart.substring(0, servicesPart.contains(";") ? servicesPart.indexOf(";") : servicesPart.length()), this.apiKey);
            request.setPath(Arrays.stream(pathComponents).collect(Collectors.joining("/", "/", "")));
        }
    }

    private boolean isPathAServicesRequest(String path) {
        return path.startsWith("/services/") || path.startsWith("/services;");
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public String toString() {
        return "KoordinatesKeySecret()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KoordinatesKeySecret)) {
            return false;
        }
        KoordinatesKeySecret other = (KoordinatesKeySecret)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        return !(this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KoordinatesKeySecret;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        return result;
    }
}

