/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonTypeBinding
extends AbstractComplexBinding {
    GeometryFactory geometryFactory;

    public PolygonTypeBinding(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    @Override
    public QName getTarget() {
        return KML.PolygonType;
    }

    public Class getType() {
        return Polygon.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LinearRing outer = (LinearRing)node.getChildValue("outerBoundaryIs");
        LinearRing[] inner = null;
        if (node.hasChild("innerBoundaryIs")) {
            List l = node.getChildValues("innerBoundaryIs");
            inner = l.toArray(new LinearRing[l.size()]);
        }
        return this.geometryFactory.createPolygon(outer, inner);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        Polygon p = (Polygon)object;
        if ("outerBoundaryIs".equals(name.getLocalPart())) {
            return p.getExteriorRing();
        }
        if ("innerBoundaryIs".equals(name.getLocalPart()) && p.getNumInteriorRing() > 0) {
            LinearRing[] interior = new LinearRing[p.getNumInteriorRing()];
            for (int i = 0; i < interior.length; ++i) {
                interior[i] = p.getInteriorRingN(i);
            }
            return interior;
        }
        return null;
    }
}

