/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.kml.KML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;

public class PlacemarkTypeBinding
extends AbstractComplexBinding {
    private final List<String> SUPPORTED_GEOMETRY_TYPES = Arrays.asList("Point", "LineString", "Polygon", "MultiGeometry");

    @Override
    public QName getTarget() {
        return KML.PlacemarkType;
    }

    public Class getType() {
        return SimpleFeature.class;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        SimpleFeature feature = (SimpleFeature)value;
        SimpleFeatureType abstractFeatureType = feature.getFeatureType();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(abstractFeatureType);
        tb.setName("placemark");
        tb.add("Geometry", Geometry.class);
        tb.setDefaultGeometry("Geometry");
        SimpleFeatureType placemarkFeatureType = tb.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(placemarkFeatureType);
        b.init(feature);
        for (Node childObj : node.getChildren(Geometry.class)) {
            Node childNode = childObj;
            String componentName = childNode.getComponent().getName();
            if (!this.SUPPORTED_GEOMETRY_TYPES.contains(componentName)) continue;
            b.set("Geometry", childNode.getValue());
        }
        return b.buildFeature(feature.getID());
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        SimpleFeature feature = (SimpleFeature)object;
        if (KML.Geometry.getLocalPart().equals(name.getLocalPart()) || org.geotools.kml.v22.KML.AbstractGeometryGroup.getLocalPart().equals(name.getLocalPart())) {
            return feature.getDefaultGeometry();
        }
        return null;
    }
}

