/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xsd.AbstractSimpleBinding;
import org.geotools.xsd.InstanceComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;

public class CoordinatesTypeBinding
extends AbstractSimpleBinding {
    CoordinateSequenceFactory csFactory;

    public CoordinatesTypeBinding(CoordinateSequenceFactory csFactory) {
        this.csFactory = csFactory;
    }

    @Override
    public QName getTarget() {
        return KML.CoordinatesType;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        List list = (List)value;
        Coordinate[] coordinates = new Coordinate[list.size()];
        int i = 0;
        for (String s : list) {
            StringTokenizer st = new StringTokenizer(s, ",");
            Coordinate c = new Coordinate();
            c.x = Double.parseDouble(st.nextToken());
            c.y = Double.parseDouble(st.nextToken());
            if (st.hasMoreTokens()) {
                c.setZ(Double.parseDouble(st.nextToken()));
            }
            coordinates[i++] = c;
        }
        return this.csFactory.create(coordinates);
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        StringBuffer sb = new StringBuffer();
        CoordinateSequence cs = (CoordinateSequence)object;
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate c = cs.getCoordinate(i);
            sb.append(c.x).append(",").append(c.y);
            if (cs.getDimension() == 3 && !Double.isNaN(c.getZ())) {
                sb.append(",").append(c.getZ());
            }
            sb.append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

