/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.api.metadata.quality.QuantitativeResult;
import org.geotools.api.metadata.quality.Result;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.MemberName;
import org.geotools.api.util.Record;
import org.geotools.api.util.RecordType;
import org.geotools.metadata.iso.MetadataEntity;

public class QuantitativeResultImpl
extends MetadataEntity
implements QuantitativeResult,
Result {
    private static final long serialVersionUID = 1230713599561236060L;
    private List<Record> values;
    private RecordType valueType;
    private Unit valueUnit;
    private InternationalString errorStatistic;

    public QuantitativeResultImpl() {
    }

    public QuantitativeResultImpl(QuantitativeResult source) {
        super(source);
    }

    public QuantitativeResultImpl(double[] values) {
        this.setValues(values);
    }

    public List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public void setValues(List<Record> newValues) {
        this.values = this.copyList(newValues, this.values, Record.class);
    }

    public void setValues(double[] newValues) {
        List<Record> records;
        if (newValues == null) {
            records = null;
        } else {
            Record[] data = new Record[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                data[i] = new SimpleRecord(newValues[i]);
            }
            records = Arrays.asList(data);
        }
        this.setValues(records);
    }

    @Override
    public RecordType getValueType() {
        return this.valueType;
    }

    public void setValueType(RecordType newValue) {
        this.checkWritePermission();
        this.valueType = newValue;
    }

    public Unit getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(Unit newValue) {
        this.checkWritePermission();
        this.valueUnit = newValue;
    }

    @Override
    public InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public void setErrorStatistic(InternationalString newValue) {
        this.checkWritePermission();
        this.errorStatistic = newValue;
    }

    private static final class SimpleRecord
    implements Record,
    Serializable {
        private final Map<MemberName, Object> map;

        public SimpleRecord(double value) {
            this.map = Collections.singletonMap(null, value);
        }

        @Override
        public RecordType getRecordType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<MemberName, Object> getAttributes() {
            return this.map;
        }

        @Override
        public Object locate(MemberName name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(MemberName name, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleRecord) {
                return this.map.equals(((SimpleRecord)other).map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

