/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.usgs;

import com.google.common.collect.Range;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.BaseBookmarkResolver;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.coverage.Dataset2D;
import nz.org.riskscape.engine.data.coverage.DatasetCoverage;
import nz.org.riskscape.engine.data.coverage.MappedCoverage;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.usgs.UsgsProblems;
import nz.org.riskscape.usgs.UsgsShakeMapMultiDatasetReader;
import nz.org.riskscape.usgs.UsgsShakeMapReader;
import org.geotools.api.geometry.Bounds;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class UsgsShakeMapResolver
extends BaseBookmarkResolver<Params> {
    private static final List<String> DEFAULT_DATASETS = Arrays.asList("/arrays/imts/GREATER_OF_TWO_HORIZONTAL/PGA/mean", "/arrays/imts/GREATER_OF_TWO_HORIZONTAL/PGA/std");
    private static final float DEFAULT_PERCENTILE = 50.0f;

    public UsgsShakeMapResolver(Engine engine) {
        super(engine);
    }

    public Set<String> getFormats() {
        return Collections.singleton("usgs-shakemap");
    }

    protected Map<String, String> getExtensionsToFormats() {
        return Collections.emptyMap();
    }

    protected void validateParameters(Params params, BindingContext context) {
        super.validateParameters((BookmarkParameters)params, context);
        if (params.percentile.isPresent()) {
            Range range;
            if (!params.dataset.isEmpty()) {
                params.problems.add(ParamProblems.get().mutuallyExclusive("percentile", "dataset"));
            }
            if (!(range = Range.closed((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(100.0f))).contains((Comparable)params.percentile.get())) {
                params.problems.add(GeneralProblems.get().valueOutOfRange((Object)"percentile", (Comparable)params.percentile.get(), range));
            }
        }
    }

    protected ResultOrProblems<? extends Object> build(Params parameters) {
        Path hdf5 = this.getBookmarkedPath(parameters);
        return ProblemException.catching(() -> {
            try (H5File file = new H5File(hdf5);){
                boolean isDefaultCoverage = parameters.dataset.isEmpty();
                List<String> datasets = isDefaultCoverage ? DEFAULT_DATASETS : parameters.dataset;
                UsgsShakeMapReader reader = datasets.size() == 1 ? new UsgsShakeMapReader(file, datasets.get(0)) : new UsgsShakeMapMultiDatasetReader(file, datasets);
                ReferencedEnvelope sourceExtent = (ReferencedEnvelope)reader.getExtent().getOrThrow();
                Dataset2D pgaData = (Dataset2D)reader.getData().getOrThrow();
                DatasetCoverage.GridStartPoint dataStartsAt = DatasetCoverage.GridStartPoint.NORTH_WEST_CORNER;
                DatasetCoverage coverage = new DatasetCoverage((Bounds)sourceExtent, pgaData, dataStartsAt, parameters.getProject().getSridSet());
                if (isDefaultCoverage) {
                    float percentile = parameters.percentile.orElse(Float.valueOf(50.0f)).floatValue();
                    TypedCoverage typedCoverage = (TypedCoverage)MappedCoverage.build((RealizationContext)parameters.getRealizationContext(), (TypedCoverage)coverage, (String)"sampled", (Expression)ExpressionParser.INSTANCE.parse(String.format("lognorm_ppf(%f / 100, sampled.mean, sampled.std)", Float.valueOf(percentile)))).getOrThrow();
                    return typedCoverage;
                }
                DatasetCoverage datasetCoverage = coverage;
                return datasetCoverage;
            }
            catch (HDF5Exception ex) {
                throw new ProblemException((Problems)Problems.caught((Throwable)ex));
            }
        }).composeProblems(UsgsProblems.get().badShakemap(hdf5));
    }

    public static class Params
    extends BookmarkParameters {
        @ParameterField
        public Optional<Float> percentile = Optional.empty();
        @ParameterField
        public List<String> dataset = Collections.emptyList();

        public Class<?> getDataType() {
            return TypedCoverage.class;
        }
    }
}

