/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.usgs;

import hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import lombok.Generated;
import nz.org.riskscape.engine.data.coverage.Dataset2D;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.hdf5.H5Attribute;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5DatasetPath;
import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.hdf5.H5Object;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class UsgsShakeMapReader {
    private final H5File file;
    private final String datasetName;

    protected H5Dataset openDataset(String dataset) {
        return this.file.openDataset(H5DatasetPath.parse((String)dataset));
    }

    public ResultOrProblems<Dataset2D> getData() {
        return this.getDataset2D(this.datasetName);
    }

    protected ResultOrProblems<Dataset2D> getDataset2D(String datasetPath) {
        ResultOrProblems resultOrProblems;
        block8: {
            H5Dataset dataset = this.openDataset(datasetPath);
            try {
                double[] values = dataset.getElementsAsDouble();
                long[] dimensions = dataset.getDataSpace().getExtent();
                int height = (int)dimensions[0];
                int width = (int)dimensions[1];
                resultOrProblems = ResultOrProblems.of((Object)Dataset2D.fromDoubles((int)width, (int)height, (double[])values));
                if (dataset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataset != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HDF5SymbolTableException ex) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().noSuchObjectExists(datasetPath, H5Dataset.class)});
                }
            }
            dataset.close();
        }
        return resultOrProblems;
    }

    public ResultOrProblems<ReferencedEnvelope> getExtent() {
        ResultOrProblems resultOrProblems;
        block8: {
            H5Dataset dataset = this.openDataset(this.datasetName);
            try {
                DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
                resultOrProblems = ProblemException.catching(() -> UsgsShakeMapReader.lambda$getExtent$0(dataset, (CoordinateReferenceSystem)crs)).composeProblems(Problems.foundWith(H5Dataset.class, (String)this.datasetName, (Problem[])new Problem[0]));
                if (dataset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataset != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HDF5SymbolTableException ex) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().noSuchObjectExists(this.datasetName, H5Dataset.class)});
                }
            }
            dataset.close();
        }
        return resultOrProblems;
    }

    @Generated
    public UsgsShakeMapReader(H5File file, String datasetName) {
        this.file = file;
        this.datasetName = datasetName;
    }

    private static /* synthetic */ ReferencedEnvelope lambda$getExtent$0(H5Dataset dataset, CoordinateReferenceSystem crs) throws ProblemException {
        double xMax = (Double)H5Attribute.readValue((H5Object)dataset, (String)"xmax", Double.class).getOrThrow();
        double xMin = (Double)H5Attribute.readValue((H5Object)dataset, (String)"xmin", Double.class).getOrThrow();
        double yMax = (Double)H5Attribute.readValue((H5Object)dataset, (String)"ymax", Double.class).getOrThrow();
        double yMin = (Double)H5Attribute.readValue((H5Object)dataset, (String)"ymin", Double.class).getOrThrow();
        return new ReferencedEnvelope(xMin, xMax, yMin, yMax, crs);
    }
}

