/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.usgs;

import java.util.ArrayList;
import java.util.List;
import nz.org.riskscape.engine.data.coverage.Dataset2D;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.hdf5.H5DatasetPath;
import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.usgs.UsgsProblems;
import nz.org.riskscape.usgs.UsgsShakeMapReader;

public class UsgsShakeMapMultiDatasetReader
extends UsgsShakeMapReader {
    private final List<String> datasetNames;

    public UsgsShakeMapMultiDatasetReader(H5File hdf5File, List<String> datasetNames) {
        super(hdf5File, datasetNames.get(0));
        this.datasetNames = datasetNames;
    }

    @Override
    public ResultOrProblems<Dataset2D> getData() {
        return ProblemException.catching(() -> {
            void var3_6;
            ArrayList<Dataset2D> datasets = new ArrayList<Dataset2D>();
            for (String string : this.datasetNames) {
                datasets.add((Dataset2D)this.getDataset2D(string).getOrThrow());
            }
            Dataset2D check = (Dataset2D)datasets.get(0);
            for (Dataset2D dataset : datasets) {
                if (dataset.getHeight() == check.getHeight() && dataset.getWidth() == check.getWidth()) continue;
                throw new ProblemException((Problems)UsgsProblems.get().datasetSizeMismatch());
            }
            Struct struct = Struct.EMPTY_STRUCT;
            for (int i = 0; i < this.datasetNames.size(); ++i) {
                String name = this.uniqueName(this.datasetNames.get(i), var3_6.getMemberKeys());
                Struct struct2 = var3_6.add(name, ((Dataset2D)datasets.get(i)).getType());
            }
            return Dataset2D.combine(datasets, (Struct)var3_6);
        });
    }

    private String uniqueName(String datasetPath, List<String> existingKeys) {
        String name = null;
        ArrayList<String> nameParts = new ArrayList<String>();
        do {
            H5DatasetPath path = H5DatasetPath.parse((String)datasetPath);
            nameParts.add(0, path.getDatasetName());
            name = String.join((CharSequence)"_", nameParts);
            datasetPath = path.getGroupName();
        } while (existingKeys.contains(name) && !datasetPath.equals("/"));
        return name;
    }
}

