/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonSpawner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Reaper
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Reaper.class);
    private static final int SLEEP_TIME_MILLIS = 100;
    private final Object reaperWakeup = new Object();
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CPythonSpawner spawner;

    Reaper(CPythonSpawner spawner) {
        super("reaper");
        this.setDaemon(true);
        this.spawner = spawner;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("CPython process reaper thread starting");
        while (true) {
            try {
                boolean noOutputCaptured;
                do {
                    if (!this.stopped.get()) continue;
                    log.info("Reaper thread stopping");
                    return;
                } while (!(noOutputCaptured = this.spawner.checkProcesses()));
                Object object = this.reaperWakeup;
                synchronized (object) {
                    this.reaperWakeup.wait(100L);
                    continue;
                }
            }
            catch (Throwable t) {
                log.error("Error during reaper loop - {}", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopReaping() {
        this.stopped.set(true);
        this.spawner.killAll();
        if (this.isAlive()) {
            Object object = this.reaperWakeup;
            synchronized (object) {
                this.reaperWakeup.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup() {
        Object object = this.reaperWakeup;
        synchronized (object) {
            this.reaperWakeup.notify();
        }
    }
}

