/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonProblems;
import nz.org.riskscape.cpython.CPythonSettings;
import nz.org.riskscape.cpython.Reaper;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPythonSpawner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CPythonSpawner.class);
    private final CPythonSettings settings;
    private final LinkedList<CPythonProcess> processes = new LinkedList();
    private final ProblemSink problemSink;
    private final Reaper reaper;

    public CPythonSpawner(CPythonSettings settings, ProblemSink problemSink) {
        this.settings = settings;
        this.problemSink = problemSink;
        this.reaper = new Reaper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPythonProcess startWrapperScript(Object errorContext, Resource userScript, Project project, String ... scriptArgs) {
        List<String> commandParts = this.settings.newPython3Command();
        commandParts.add(this.settings.getAdaptorPath().toString());
        try {
            Path localPath = (Path)userScript.ensureLocal(Resource.SECURE_OPTIONS, ".py").orElseThrow(problems -> new RiskscapeException((Problems)Problems.toSingleProblem((List)problems)));
            commandParts.add(localPath.toFile().toString());
        }
        catch (RiskscapeException e) {
            throw new RiskscapeException((Problems)CPythonProblems.get().failedToLoadScript(errorContext).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
        }
        URI relativeTo = project.getRelativeTo();
        try {
            Optional localPath = project.getEngine().getResourceFactory().load(project.getRelativeTo()).getLocal();
            if (localPath.isPresent()) {
                relativeTo = ((Path)localPath.get()).toUri();
            }
        }
        catch (ResourceLoadingException localPath) {
            // empty catch block
        }
        String projectRoot = ((URI)UriHelper.uriFromLocation((String)".", (URI)relativeTo).get()).getPath();
        commandParts.add(projectRoot);
        commandParts.addAll(Arrays.asList(scriptArgs));
        CPythonProcess process = null;
        try {
            process = this.spawn(userScript, commandParts);
            Object result = Types.BOOLEAN.fromBytes(process.childStdOut);
            if (!Boolean.TRUE.equals(result)) {
                throw new RiskscapeException((Problems)CPythonProblems.get().failedToStartScript(errorContext, process.getErrorText()));
            }
        }
        catch (IOException e) {
            String errorText = process == null ? e.getMessage() : process.getErrorText();
            throw new RiskscapeException((Problems)CPythonProblems.get().failedToStartScript(errorContext, errorText), (Throwable)e);
        }
        LinkedList<CPythonProcess> linkedList = this.processes;
        synchronized (linkedList) {
            this.processes.add(process);
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPythonProcess startExecScript(Object errorContext, Resource userScript, String ... scriptArgs) {
        List<String> commandParts = this.settings.newPython3Command();
        commandParts.add(this.settings.getExecAdaptorPath().toString());
        try {
            Path localPath = (Path)userScript.ensureLocal(Resource.SECURE_OPTIONS).orElseThrow(problems -> new RiskscapeException((Problems)Problems.toSingleProblem((List)problems)));
            commandParts.add(localPath.toFile().toString());
        }
        catch (RiskscapeException e) {
            throw new RiskscapeException((Problems)CPythonProblems.get().failedToLoadScript(errorContext).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
        }
        commandParts.addAll(Arrays.asList(scriptArgs));
        CPythonProcess process = null;
        try {
            process = this.spawn(userScript, commandParts);
            Object result = Types.BOOLEAN.fromBytes(process.childStdOut);
            if (!Boolean.TRUE.equals(result)) {
                throw new RiskscapeException((Problems)CPythonProblems.get().failedToStartScript(errorContext, process.getErrorText()));
            }
        }
        catch (IOException e) {
            String errorText = process == null ? e.getMessage() : process.getErrorText();
            throw new RiskscapeException((Problems)CPythonProblems.get().failedToStartScript(errorContext, errorText), (Throwable)e);
        }
        LinkedList<CPythonProcess> linkedList = this.processes;
        synchronized (linkedList) {
            this.processes.add(process);
        }
        return process;
    }

    CPythonProcess spawn(Resource scriptDescription, List<String> commandParts) throws IOException {
        String[] command = commandParts.toArray(new String[commandParts.size()]);
        log.info("Launching command {}", commandParts);
        Process child = Runtime.getRuntime().exec(command);
        return new CPythonProcess(child, scriptDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean checkProcesses() {
        LinkedList<CPythonProcess> snaphost;
        LinkedList<CPythonProcess> linkedList = this.processes;
        synchronized (linkedList) {
            snaphost = new LinkedList<CPythonProcess>(this.processes);
        }
        ListIterator iter = snaphost.listIterator();
        boolean noOutputCaptured = true;
        while (iter.hasNext()) {
            CPythonProcess toCheck = (CPythonProcess)iter.next();
            if (toCheck.hasErrorText()) {
                String errorText = toCheck.getErrorText();
                List<String> lines = Arrays.asList(errorText.split(OsUtils.LINE_SEPARATOR));
                for (String line : lines) {
                    this.problemSink.log(CPythonProblems.get().functionOutput(toCheck.getUserScript(), line.trim()));
                }
                noOutputCaptured = false;
            }
            if (toCheck.isAlive()) continue;
            if (!toCheck.wasDestroyed() && toCheck.child.exitValue() != 0) {
                log.warn("Non-zero exit status ({}) from Cpython process {}", (Object)toCheck.child.exitValue(), (Object)toCheck);
            }
            LinkedList<CPythonProcess> linkedList2 = this.processes;
            synchronized (linkedList2) {
                log.info("Removing dead cpython process {}", (Object)toCheck);
                this.processes.remove(toCheck);
            }
        }
        return noOutputCaptured;
    }

    public void checkForOutputAndWait() {
        boolean finished = false;
        while (!finished) {
            finished = this.checkProcesses();
        }
    }

    public void checkForOutput() {
        this.reaper.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        LinkedList<CPythonProcess> linkedList = this.processes;
        synchronized (linkedList) {
            for (CPythonProcess cPythonProcess : this.processes) {
                log.info("forcibly destroying {}", (Object)cPythonProcess);
                cPythonProcess.destroy();
            }
            this.processes.clear();
        }
    }

    private String pathToExecute(URI uri) {
        return Paths.get(uri).toFile().toString();
    }

    public void destroy() {
        this.reaper.stopReaping();
    }

    @Generated
    public CPythonSettings getSettings() {
        return this.settings;
    }

    public class CPythonProcess {
        private final Process child;
        private final Resource userScript;
        private final DataOutputStream childStdIn;
        private final DataInputStream childStdOut;
        volatile String lastErrorText;
        volatile boolean destroyed;

        public CPythonProcess(Process proc, Resource script) {
            this.child = proc;
            this.userScript = script;
            this.childStdIn = new DataOutputStream(this.child.getOutputStream());
            this.childStdOut = new DataInputStream(this.child.getInputStream());
        }

        public String getErrorText() {
            if (this.destroyed) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            InputStream is = this.child.getErrorStream();
            byte[] buf = new byte[1024];
            try {
                while (is.available() > 0) {
                    int bytesRead = is.read(buf);
                    builder.append(new String(buf, 0, bytesRead));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.lastErrorText = builder.toString();
            return this.lastErrorText;
        }

        public boolean hasErrorText() {
            if (this.destroyed) {
                return false;
            }
            try {
                return this.child.getErrorStream().available() > 0;
            }
            catch (IOException e) {
                if (this.child.isAlive()) {
                    throw new UncheckedIOException(e);
                }
                log.warn("Failed to read stderr from dead process {} - we may have missed output", (Object)this);
                return false;
            }
        }

        public boolean exittedOK() {
            try {
                this.child.waitFor(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.child.isAlive()) {
                this.child.destroyForcibly();
                return false;
            }
            return this.child.exitValue() == 0;
        }

        public void destroy() {
            this.destroyed = true;
            this.child.destroyForcibly();
        }

        public String toString() {
            this.child.toString();
            return String.format("CPythonProcess(script=%s alive?=%s)", this.userScript.getLocation(), this.child.isAlive());
        }

        public boolean isAlive() {
            return !this.destroyed && this.child.isAlive();
        }

        public boolean wasDestroyed() {
            return this.destroyed;
        }

        public int join() throws InterruptedException {
            return this.child.waitFor();
        }

        @Generated
        public Process getChild() {
            return this.child;
        }

        @Generated
        public Resource getUserScript() {
            return this.userScript;
        }

        @Generated
        public DataOutputStream getChildStdIn() {
            return this.childStdIn;
        }

        @Generated
        public DataInputStream getChildStdOut() {
            return this.childStdOut;
        }
    }
}

