/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonProblems;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.resource.FileResource;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.problem.ProblemSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPythonSettings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CPythonSettings.class);
    public static final String DEFAULT_ADAPTOR_PATH = "rs2CPyAdaptor.py";
    public static final String DEFAULT_EXEC_ADAPTOR_PATH = "rs2CPyExecAdaptor.py";
    public static final String DEFAULT_PYTHON3_OPTIONS = "";
    public static final String NOT_SET = "";
    private static final String DEFAULT_LINUX_PYTHON_LOCATION = System.getenv().getOrDefault("RS_PYTHON3_BIN", "/usr/bin/python3");
    private String python3Bin;
    private Path adaptorPath;
    private Path execAdaptorPath;
    private List<String> python3Options;
    private Path libDir;
    private int maxProcessesPerFunction;

    public static CPythonSettings defaults(Path libDir, String python3bin) {
        HashMap<String, List<String>> settings = new HashMap<String, List<String>>();
        settings.put("cpython.python3-bin", Arrays.asList(python3bin));
        return CPythonSettings.fromIniSection(libDir, settings);
    }

    public static CPythonSettings fromIniSection(Path pluginInstallPath, Map<String, List<String>> iniSection) {
        CPythonSettings settings = new CPythonSettings();
        settings.libDir = pluginInstallPath.resolve(CPythonSettings.getOrDefault("lib-dir", iniSection, "."));
        settings.python3Bin = CPythonSettings.getOrDefault("python3-bin", iniSection, "");
        if (settings.python3Bin == "" && OsUtils.isLinux() && new File(DEFAULT_LINUX_PYTHON_LOCATION).canExecute()) {
            log.info("Using default python3 install location of {}", (Object)DEFAULT_LINUX_PYTHON_LOCATION);
            settings.python3Bin = DEFAULT_LINUX_PYTHON_LOCATION;
        }
        settings.adaptorPath = settings.libDir.resolve(CPythonSettings.getOrDefault("adaptor-script", iniSection, DEFAULT_ADAPTOR_PATH));
        settings.execAdaptorPath = settings.libDir.resolve(CPythonSettings.getOrDefault("exec-adaptor-script", iniSection, DEFAULT_EXEC_ADAPTOR_PATH));
        settings.python3Options = iniSection.getOrDefault("python3-add-option", Collections.emptyList());
        settings.maxProcessesPerFunction = Integer.parseInt(CPythonSettings.getOrDefault("max-processes", iniSection, Integer.toString(Runtime.getRuntime().availableProcessors())));
        return settings;
    }

    public boolean isPython3BinSet() {
        return this.python3Bin != "";
    }

    public boolean checkPython3Working(ProblemSink problemSink) {
        CPythonSpawner.CPythonProcess process;
        Path checkPythonScript = this.libDir.resolve("checkPython.py");
        List<String> checkCommand = this.newPython3Command();
        checkCommand.add(checkPythonScript.toString());
        try {
            process = new CPythonSpawner(this, problemSink).spawn((Resource)new FileResource(checkPythonScript), checkCommand);
        }
        catch (IOException e) {
            problemSink.log(CPythonProblems.get().failedToStartPlugin(e.getMessage()));
            return false;
        }
        boolean exittedOk = process.exittedOK();
        if (!exittedOk) {
            String errorText = process.getErrorText();
            problemSink.log(CPythonProblems.get().failedToStartPlugin(errorText));
            return false;
        }
        if (!this.getAdaptorPath().toFile().canRead()) {
            problemSink.log(CPythonProblems.get().failedToStartPlugin("can not read " + String.valueOf(this.getAdaptorPath())));
            return false;
        }
        return true;
    }

    public List<String> newPython3Command() {
        LinkedList<String> command = new LinkedList<String>();
        command.add(this.python3Bin);
        command.addAll(this.python3Options);
        return command;
    }

    private static String getOrDefault(String key, Map<String, List<String>> section, String defaultValue) {
        List<String> values = section.get("cpython." + key);
        if (values == null || values.size() == 0) {
            return defaultValue;
        }
        return values.get(0);
    }

    @Generated
    public String getPython3Bin() {
        return this.python3Bin;
    }

    @Generated
    public Path getAdaptorPath() {
        return this.adaptorPath;
    }

    @Generated
    public Path getExecAdaptorPath() {
        return this.execAdaptorPath;
    }

    @Generated
    public List<String> getPython3Options() {
        return this.python3Options;
    }

    @Generated
    public Path getLibDir() {
        return this.libDir;
    }

    @Generated
    public int getMaxProcessesPerFunction() {
        return this.maxProcessesPerFunction;
    }

    @Generated
    public String toString() {
        return "CPythonSettings(python3Bin=" + this.getPython3Bin() + ", adaptorPath=" + String.valueOf(this.getAdaptorPath()) + ", execAdaptorPath=" + String.valueOf(this.getExecAdaptorPath()) + ", python3Options=" + String.valueOf(this.getPython3Options()) + ", libDir=" + String.valueOf(this.getLibDir()) + ", maxProcessesPerFunction=" + this.getMaxProcessesPerFunction() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CPythonSettings)) {
            return false;
        }
        CPythonSettings other = (CPythonSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxProcessesPerFunction() != other.getMaxProcessesPerFunction()) {
            return false;
        }
        String this$python3Bin = this.getPython3Bin();
        String other$python3Bin = other.getPython3Bin();
        if (this$python3Bin == null ? other$python3Bin != null : !this$python3Bin.equals(other$python3Bin)) {
            return false;
        }
        Path this$adaptorPath = this.getAdaptorPath();
        Path other$adaptorPath = other.getAdaptorPath();
        if (this$adaptorPath == null ? other$adaptorPath != null : !((Object)this$adaptorPath).equals(other$adaptorPath)) {
            return false;
        }
        Path this$execAdaptorPath = this.getExecAdaptorPath();
        Path other$execAdaptorPath = other.getExecAdaptorPath();
        if (this$execAdaptorPath == null ? other$execAdaptorPath != null : !((Object)this$execAdaptorPath).equals(other$execAdaptorPath)) {
            return false;
        }
        List<String> this$python3Options = this.getPython3Options();
        List<String> other$python3Options = other.getPython3Options();
        if (this$python3Options == null ? other$python3Options != null : !((Object)this$python3Options).equals(other$python3Options)) {
            return false;
        }
        Path this$libDir = this.getLibDir();
        Path other$libDir = other.getLibDir();
        return !(this$libDir == null ? other$libDir != null : !((Object)this$libDir).equals(other$libDir));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CPythonSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxProcessesPerFunction();
        String $python3Bin = this.getPython3Bin();
        result = result * 59 + ($python3Bin == null ? 43 : $python3Bin.hashCode());
        Path $adaptorPath = this.getAdaptorPath();
        result = result * 59 + ($adaptorPath == null ? 43 : ((Object)$adaptorPath).hashCode());
        Path $execAdaptorPath = this.getExecAdaptorPath();
        result = result * 59 + ($execAdaptorPath == null ? 43 : ((Object)$execAdaptorPath).hashCode());
        List<String> $python3Options = this.getPython3Options();
        result = result * 59 + ($python3Options == null ? 43 : ((Object)$python3Options).hashCode());
        Path $libDir = this.getLibDir();
        result = result * 59 + ($libDir == null ? 43 : ((Object)$libDir).hashCode());
        return result;
    }
}

