/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WrappingType;
import nz.org.riskscape.engine.util.Pair;

public class CPythonSerializer {
    public static final Map<Class<?>, String> TYPE_ALIASES = ImmutableMap.of(RSList.class, (Object)"List", Geom.class, (Object)"Geometry");
    private static final Map<Type, Type> NULL_SAFE_MAPPINGS = ImmutableMap.of((Object)Types.BOOLEAN, (Object)Nullable.BOOLEAN, (Object)Types.INTEGER, (Object)Nullable.INTEGER, (Object)Types.FLOATING, (Object)Nullable.FLOATING, (Object)Types.TEXT, (Object)Nullable.TEXT);

    public static String serializerType(Type type) {
        final StringBuilder builder = new StringBuilder();
        type.visit((TypeVisitor)new TypeVisitor<Void, Void>(){

            public Void atomicType(Type simpleType, Void ignored) {
                this.append(simpleType);
                return null;
            }

            public Void compoundType(Type type, List<Pair<Type, ?>> children, Void ignored) {
                if (type instanceof WrappingType) {
                    return (Void)((WrappingType)type).getUnderlyingType().visit((TypeVisitor)this, (Object)ignored);
                }
                this.append(type).append("[");
                boolean first = true;
                for (Pair<Type, ?> pair : children) {
                    if (!first) {
                        builder.append(", ");
                    }
                    first = false;
                    Type childType = (Type)pair.getLeft();
                    Object meta = pair.getRight();
                    if (meta != TypeVisitor.NO_META) {
                        builder.append(meta.toString()).append("=>");
                    }
                    childType.visit((TypeVisitor)this, null);
                }
                builder.append("]");
                return null;
            }

            private StringBuilder append(Type type) {
                builder.append(TYPE_ALIASES.getOrDefault(type.getClass(), type.getClass().getSimpleName()));
                return builder;
            }
        }, null);
        return builder.toString();
    }

    public void serialize(DataOutputStream output, Type type, Object value) throws IOException {
        Optional structOr = type.find(Struct.class);
        if (structOr.isPresent()) {
            this.serializeStruct(output, (Struct)structOr.get(), value);
        } else if (type instanceof WrappingType) {
            this.serialize(output, ((WrappingType)type).getUnderlyingType(), value);
        } else {
            CPythonSerializer.nullSafeSimpleType(type).toBytes(output, value);
        }
    }

    private void serializeStruct(DataOutputStream output, Struct struct, Object toWrite) throws IOException {
        Tuple tuple = (Tuple)toWrite;
        for (Struct.StructMember member : struct.getMembers()) {
            this.serialize(output, member.getType(), tuple.fetch(member));
        }
    }

    public static Type nullSafeType(Type type) {
        Optional structOr = type.find(Struct.class);
        if (structOr.isPresent()) {
            return CPythonSerializer.nullSafeStruct((Struct)structOr.get());
        }
        if (type instanceof WrappingType) {
            return CPythonSerializer.nullSafeType(((WrappingType)type).getUnderlyingType());
        }
        return CPythonSerializer.nullSafeSimpleType(type);
    }

    private static Type nullSafeSimpleType(Type type) {
        for (Map.Entry<Type, Type> typeMapping : NULL_SAFE_MAPPINGS.entrySet()) {
            if (!typeMapping.getKey().equals(type)) continue;
            return typeMapping.getValue();
        }
        return type;
    }

    private static Type nullSafeStruct(Struct struct) {
        Struct.StructBuilder builder = Struct.builder();
        for (Struct.StructMember member : struct.getMembers()) {
            builder.add(member.getKey(), CPythonSerializer.nullSafeType(member.getType()));
        }
        return builder.build();
    }
}

