/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonFunction;
import nz.org.riskscape.cpython.CPythonSerializer;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UserDefinedFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class CPythonRealizableFunction
extends UserDefinedFunction {
    final CPythonSpawner runner;
    private final Project project;

    public CPythonRealizableFunction(FunctionMetadata details, Resource pythonScript, CPythonSpawner runner, Project project) {
        super(details, pythonScript);
        this.runner = runner;
        this.project = project;
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        if (this.areArgumentsCompatible(context, argumentTypes)) {
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new FunctionFactory(argumentTypes), this.getPoolConfig());
            return ResultOrProblems.of((Object)new CPythonFunction(argumentTypes, this, (GenericObjectPool<CPythonSpawner.CPythonProcess>)pool));
        }
        return ResultOrProblems.failed((List)this.getArgumentProblems(context, argumentTypes));
    }

    private GenericObjectPoolConfig<CPythonSpawner.CPythonProcess> getPoolConfig() {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setLifo(true);
        poolConfig.setFairness(false);
        poolConfig.setJmxEnabled(false);
        poolConfig.setMaxWait(Duration.ofMillis(-1L));
        poolConfig.setBlockWhenExhausted(true);
        poolConfig.setTestOnBorrow(false);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestOnReturn(false);
        poolConfig.setMaxTotal(this.runner.getSettings().getMaxProcessesPerFunction());
        poolConfig.setMaxIdle(this.runner.getSettings().getMaxProcessesPerFunction());
        poolConfig.setMinIdle(0);
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(-1L));
        return poolConfig;
    }

    class FunctionFactory
    extends BasePooledObjectFactory<CPythonSpawner.CPythonProcess> {
        private final List<Type> argumentTypes;

        public CPythonSpawner.CPythonProcess create() throws Exception {
            ArrayList<String> pyArgs = new ArrayList<String>();
            pyArgs.add(CPythonSerializer.serializerType(CPythonRealizableFunction.this.getMetadata().getReturnType()));
            this.argumentTypes.forEach(type -> pyArgs.add(CPythonSerializer.serializerType(CPythonSerializer.nullSafeType(type))));
            CPythonSpawner.CPythonProcess childProcess = CPythonRealizableFunction.this.runner.startWrapperScript(CPythonRealizableFunction.this.identified(), CPythonRealizableFunction.this.getScript(), CPythonRealizableFunction.this.project, pyArgs.toArray(new String[pyArgs.size()]));
            return childProcess;
        }

        public void destroyObject(PooledObject<CPythonSpawner.CPythonProcess> p) throws Exception {
            ((CPythonSpawner.CPythonProcess)p.getObject()).destroy();
        }

        public PooledObject<CPythonSpawner.CPythonProcess> wrap(CPythonSpawner.CPythonProcess obj) {
            return new DefaultPooledObject((Object)obj);
        }

        @Generated
        public FunctionFactory(List<Type> argumentTypes) {
            this.argumentTypes = argumentTypes;
        }
    }
}

