/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonExecStep;
import nz.org.riskscape.cpython.CPythonFunctionFramework;
import nz.org.riskscape.cpython.CPythonSettings;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;

public class CPythonPlugin
extends Plugin {
    @Nullable
    private CPythonSettings settings;
    private boolean checkPassed = false;
    private CPythonSpawner spawner;

    public CPythonPlugin(PluginDescriptor pDescriptor) {
        super(pDescriptor);
    }

    public void startUp(Map<String, List<String>> iniSection, ProblemSink problemSink) throws PluginRuntimeException {
        super.startUp(iniSection);
        Path pluginPath = this.getDescriptor().getSourcePath();
        this.settings = CPythonSettings.fromIniSection(pluginPath, iniSection);
        if (this.settings.isPython3BinSet()) {
            this.checkPassed = this.settings.checkPython3Working(problemSink);
        }
    }

    public List<Problem> initializeEngine(Engine engine) {
        CPythonFunctionFramework functionFramework;
        if (this.checkPassed) {
            this.spawner = new CPythonSpawner(this.settings, engine.getProblemSink());
            functionFramework = new CPythonFunctionFramework(this.spawner);
            if (engine.isBetaPluginEnabled()) {
                engine.getPipelineSteps().add((Identified)new CPythonExecStep(engine, this.spawner));
            }
        } else {
            functionFramework = CPythonFunctionFramework.notEnabled();
        }
        engine.getFunctionFrameworks().add((Identified)functionFramework);
        return Collections.emptyList();
    }

    public void shutDown() throws PluginRuntimeException {
        if (this.spawner != null) {
            this.spawner.destroy();
        }
    }

    @Generated
    public CPythonSpawner getSpawner() {
        return this.spawner;
    }
}

