/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonFunction;
import nz.org.riskscape.cpython.CPythonRealizableFunction;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionFramework;
import nz.org.riskscape.engine.function.FunctionFrameworkSupport;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.MetadataParams;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeRegistry;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.WrappingType;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class CPythonFunctionFramework
implements FunctionFramework,
FunctionFrameworkSupport {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final CPythonSpawner spawner;
    private final String id = "cpython";
    private final JavaParameterSet<MetadataParams> parameterSet = JavaParameterSet.fromBindingClass(MetadataParams.class);

    public static CPythonFunctionFramework notEnabled() {
        return new CPythonFunctionFramework(null){

            @Override
            public boolean canBuild(Project project, Map<String, List<?>> unbound) {
                return false;
            }

            @Override
            public ResultOrProblems<IdentifiedFunction> build(String functionName, Project project, BoundParameters bound) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.notEnabled()});
            }
        };
    }

    public ResultOrProblems<IdentifiedFunction> build(String functionName, Project project, BoundParameters bound) {
        MetadataParams params = (MetadataParams)this.parameterSet.bindToObject(bound).getBoundToObject();
        return this.loadFunctionFromParams(project.getEngine(), params).flatMap(resource -> this.build(project, params.toFunctionMetadata(functionName), (Resource)resource)).composeProblems(Problems.foundWith(IdentifiedFunction.class, (String)functionName, (Problem[])new Problem[0]));
    }

    ResultOrProblems<IdentifiedFunction> build(Project project, FunctionMetadata metadata, Resource pythonScript) {
        List<Problem> problems = this.checkMetadataValid(project.getTypeSet().getTypeRegistry(), metadata);
        if (!problems.isEmpty()) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of((Object)new CPythonRealizableFunction(metadata, pythonScript, this.spawner, project).identified());
    }

    public boolean canBuild(Project project, Map<String, List<?>> unbound) {
        return MetadataParams.locationEndsWith(unbound, (String)".py");
    }

    private List<Problem> checkMetadataValid(TypeRegistry registry, FunctionMetadata function) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (function.getArguments().size() == 0) {
            problems.add(PROBLEMS.zeroArgsNotSupported());
        }
        ArgumentList args = function.getArguments();
        for (int i = 0; i < args.size(); ++i) {
            Type argsType = (Type)args.getArgumentTypes().get(i);
            for (String unsupported : CPythonFunctionFramework.findUnsupportedTypes(registry, argsType, CPythonFunction.SUPPORTED_ARGUMENT_TYPES)) {
                problems.add(PROBLEMS.typeNotSupported(unsupported, args.get(i), CPythonFunctionFramework.getSupportedArgumentTypeNames(registry)));
            }
        }
        for (String unsupported : CPythonFunctionFramework.findUnsupportedTypes(registry, function.getReturnType(), CPythonFunction.SUPPORTED_RETURN_TYPES)) {
            problems.add(PROBLEMS.typeNotSupported(unsupported, "'return-type'", this.getSupportedReturnTypeNames(registry)));
        }
        return problems;
    }

    public static List<String> findUnsupportedTypes(TypeRegistry registry, Type type, List<Class<? extends Type>> allowedTypes) {
        return (List)TypeVisitor.bfs((Type)type, new LinkedList(), (list, childType) -> {
            if (!(childType instanceof WrappingType) && !allowedTypes.contains(childType.getClass())) {
                list.add(CPythonFunctionFramework.getTypeConstructorName(registry, childType.getClass()));
            }
        });
    }

    public static List<String> getSupportedArgumentTypeNames(TypeRegistry registry) {
        return Lists.transform(CPythonFunction.SUPPORTED_ARGUMENT_TYPES, t -> CPythonFunctionFramework.getTypeConstructorName(registry, t));
    }

    List<String> getSupportedReturnTypeNames(TypeRegistry registry) {
        return Lists.transform(CPythonFunction.SUPPORTED_RETURN_TYPES, t -> CPythonFunctionFramework.getTypeConstructorName(registry, t));
    }

    private static String getTypeConstructorName(TypeRegistry registry, Class<? extends Type> someType) {
        return registry.findTypeInformation(someType).map(ti -> ti.getId()).orElse(someType.getSimpleName().toLowerCase());
    }

    public int getPriority() {
        return 10;
    }

    @Generated
    public CPythonFunctionFramework(CPythonSpawner spawner) {
        this.spawner = spawner;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public JavaParameterSet<MetadataParams> getParameterSet() {
        return this.parameterSet;
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem zeroArgsNotSupported();

        public Problem typeNotSupported(String var1, Object var2, List<String> var3);

        public Problem notEnabled();
    }
}

