/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonProblems;
import nz.org.riskscape.cpython.CPythonRealizableFunction;
import nz.org.riskscape.cpython.CPythonSerializer;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.function.FunctionCallException;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Anything;
import nz.org.riskscape.engine.types.Bool;
import nz.org.riskscape.engine.types.Enumeration;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Smallfloat;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.StandardCodes;
import org.apache.commons.pool2.impl.GenericObjectPool;

class CPythonFunction
implements RiskscapeFunction {
    public static final List<Class<? extends Type>> SUPPORTED_RETURN_TYPES = Lists.newArrayList((Object[])new Class[]{Bool.class, Integer.class, Enumeration.class, Floating.class, RSList.class, Nullable.class, Smallfloat.class, Struct.class, Text.class, Geom.class});
    public static final List<Class<? extends Type>> SUPPORTED_ARGUMENT_TYPES = Stream.concat(SUPPORTED_RETURN_TYPES.stream(), Stream.of(Anything.class)).collect(Collectors.toList());
    private final List<Type> argumentTypes;
    private final CPythonRealizableFunction realizable;
    private final GenericObjectPool<CPythonSpawner.CPythonProcess> pool;
    private final CPythonSerializer serializer = new CPythonSerializer();

    public Object call(List<Object> args) {
        CPythonSpawner.CPythonProcess process;
        try {
            process = (CPythonSpawner.CPythonProcess)this.pool.borrowObject();
        }
        catch (RiskscapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
        try {
            Object argType;
            for (int i = 0; i < this.argumentTypes.size(); ++i) {
                argType = this.argumentTypes.get(i);
                Object value = args.get(i);
                this.serializer.serialize(process.getChildStdIn(), (Type)argType, value);
            }
            process.getChildStdIn().flush();
            Long status = (Long)Types.INTEGER.fromBytes(process.getChildStdOut());
            if (process.hasErrorText()) {
                this.realizable.runner.checkForOutput();
            }
            if (status == 1L) {
                argType = this.getReturnType().fromBytes(process.getChildStdOut());
                return argType;
            }
            try {
                String errorMesssage = (String)Types.TEXT.fromBytes(process.getChildStdOut());
                throw new FunctionCallException(Problems.foundWith((Object)this.realizable.identified(), (Problems)CPythonProblems.get().functionCallException(errorMesssage)), null);
            }
            catch (EOFException ex) {
                this.realizable.runner.checkForOutputAndWait();
                throw new FunctionCallException(Problems.foundWith((Object)this.realizable.identified(), (Problems)Problem.error((ProblemCode)StandardCodes.CAUGHT_EXCEPTION, (Object[])new Object[]{process.lastErrorText})), (Exception)ex);
            }
            catch (IOException ex) {
                throw new FunctionCallException(Problems.foundWith((Object)this.realizable.identified(), (Problems)Problems.caught((Throwable)ex)), (Exception)ex);
            }
        }
        finally {
            try {
                this.pool.returnObject((Object)process);
            }
            catch (RiskscapeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
            }
        }
    }

    public Type getReturnType() {
        return this.realizable.getMetadata().getReturnType();
    }

    public void close() {
        this.realizable.runner.checkForOutputAndWait();
        this.pool.close();
    }

    public String toString() {
        return String.format("CPythonFunction[%s]", this.realizable.getMetadata());
    }

    @Generated
    public CPythonFunction(List<Type> argumentTypes, CPythonRealizableFunction realizable, GenericObjectPool<CPythonSpawner.CPythonProcess> pool) {
        this.argumentTypes = argumentTypes;
        this.realizable = realizable;
        this.pool = pool;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

