/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.cpython.CPythonAsyncProjector;
import nz.org.riskscape.cpython.CPythonFunction;
import nz.org.riskscape.cpython.CPythonFunctionFramework;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeRegistry;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class CPythonExecStep
extends BaseStep<Parameters> {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final CPythonSpawner spawner;

    public CPythonExecStep(Engine engine, CPythonSpawner spawner) {
        super(engine);
        this.spawner = spawner;
    }

    public String getId() {
        return "python";
    }

    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        Resource scriptResource;
        try {
            scriptResource = this.getEngine().getResourceFactory().load(parameters.script);
        }
        catch (ResourceLoadingException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ex.getProblem()});
        }
        TypeRegistry registry = parameters.rInput.getExecutionContext().getEngine().getTypeRegistry();
        List<String> unsupported = CPythonFunctionFramework.findUnsupportedTypes(registry, (Type)parameters.input.getProduces(), CPythonFunction.SUPPORTED_ARGUMENT_TYPES);
        if (!unsupported.isEmpty()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.typeNotSupported(parameters.input.getStepName(), unsupported, PROBLEMS.typeNotSupportedHint(parameters.input.getStepName(), parameters.input.getProduces()))});
        }
        CPythonAsyncProjector asyncProjector = new CPythonAsyncProjector(parameters.rInput.getStepDefinition(), parameters.input.getProduces(), parameters.resultType.orElse(Struct.EMPTY_STRUCT), parameters.parameters, scriptResource, this.spawner);
        if (parameters.resultType.isPresent()) {
            return ResultOrProblems.of((Object)asyncProjector);
        }
        return ResultOrProblems.of((Object)asyncProjector.getOutput());
    }

    public static class Parameters {
        @Input
        public RealizedStep input;
        public RealizationInput rInput;
        @ParameterField
        public URI script;
        @ParameterField
        public Optional<Struct> resultType;
        @ParameterField
        public Optional<Tuple> parameters;
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem typeNotSupported(String var1, List<String> var2, Problem ... var3);

        public Problem typeNotSupportedHint(String var1, Struct var2);
    }
}

