/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.cpython;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import nz.org.riskscape.cpython.CPythonProblems;
import nz.org.riskscape.cpython.CPythonSerializer;
import nz.org.riskscape.cpython.CPythonSpawner;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.FunctionCallException;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.pipeline.TupleInput;
import nz.org.riskscape.engine.projection.AsyncProjector;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class CPythonAsyncProjector
implements AsyncProjector {
    private final Object errorContext;
    private final Struct inputType;
    private final Struct producedType;
    private final Optional<Tuple> parameters;
    private final Resource script;
    private final CPythonSpawner processSpawner;
    private final AtomicBoolean inputFinished = new AtomicBoolean(false);
    private final AtomicBoolean outputFinished = new AtomicBoolean(false);
    private CPythonSpawner.CPythonProcess process;
    private PipelineJobContext context;
    private Type nullSafeInputType;
    CPythonSerializer serializer = new CPythonSerializer();
    private final TupleInput input = new TupleInput(){

        public Struct getProducedType() {
            return CPythonAsyncProjector.this.producedType;
        }

        public Tuple poll() {
            try {
                if (CPythonAsyncProjector.this.process.getChildStdOut().available() == 0) {
                    return null;
                }
                long rowCount = CPythonAsyncProjector.this.readFunctionResponse();
                if (rowCount == 1L) {
                    return (Tuple)CPythonAsyncProjector.this.producedType.fromBytes(CPythonAsyncProjector.this.process.getChildStdOut());
                }
                if (rowCount > 1L) {
                    throw new IllegalStateException(" expected one or zero");
                }
                return null;
            }
            catch (IOException e) {
                Problem problem = CPythonProblems.get().failedToReadResult(CPythonAsyncProjector.this.script, CPythonAsyncProjector.this.process.getErrorText());
                throw new FunctionCallException(problem, (Exception)e);
            }
        }

        public boolean isComplete() {
            return CPythonAsyncProjector.this.outputFinished.get();
        }

        public boolean isAsync() {
            return true;
        }

        public Optional<Long> size() {
            return Optional.empty();
        }
    };
    private final SinkConstructor output = new SinkConstructor(){

        public ResultOrProblems<Sink> newInstance(PipelineJobContext newContext) {
            CPythonAsyncProjector.this.context = newContext;
            try {
                CPythonAsyncProjector.this.start();
            }
            catch (ProblemException e) {
                return e.toResult();
            }
            return ResultOrProblems.of((Object)new Sink(){

                public void finish() {
                    CPythonAsyncProjector.this.inputFinished.set(true);
                    try {
                        CPythonAsyncProjector.this.process.getChildStdIn().writeLong(0L);
                        CPythonAsyncProjector.this.process.getChildStdIn().flush();
                        if (!CPythonAsyncProjector.this.isExpectedToProduceOutput()) {
                            CPythonAsyncProjector.this.readFunctionResponse();
                        }
                    }
                    catch (IOException e) {
                        throw new RiskscapeIOException("Failed to write tuple to cpython process:" + CPythonAsyncProjector.this.process.getErrorText(), (Exception)e);
                    }
                }

                public boolean accept(Tuple tuple) {
                    try {
                        CPythonAsyncProjector.this.process.getChildStdIn().writeLong(1L);
                        CPythonAsyncProjector.this.process.getChildStdIn().flush();
                        CPythonAsyncProjector.this.serializer.serialize(CPythonAsyncProjector.this.process.getChildStdIn(), (Type)CPythonAsyncProjector.this.inputType, tuple);
                        CPythonAsyncProjector.this.process.getChildStdIn().flush();
                    }
                    catch (IOException e) {
                        throw new RiskscapeIOException("Failed to write tuple to cpython process", (Exception)e);
                    }
                    return true;
                }
            });
        }
    };

    private void start() throws ProblemException {
        this.nullSafeInputType = CPythonSerializer.nullSafeType((Type)this.inputType);
        String outputTypeArg = CPythonSerializer.serializerType((Type)this.getProducedType());
        String inputTypeArg = CPythonSerializer.serializerType(this.nullSafeInputType);
        ArrayList<String> pyArgs = new ArrayList<String>();
        pyArgs.add(inputTypeArg);
        pyArgs.add(outputTypeArg);
        this.parameters.map(Tuple::getStruct).map(s -> CPythonSerializer.serializerType(CPythonSerializer.nullSafeType((Type)s))).ifPresent(paramArg -> pyArgs.add((String)paramArg));
        try {
            this.process = this.processSpawner.startExecScript(this.errorContext, this.script, pyArgs.toArray(new String[pyArgs.size()]));
            if (this.parameters.isPresent()) {
                Tuple t = this.parameters.get();
                this.serializer.serialize(this.process.getChildStdIn(), (Type)t.getStruct(), t);
                this.process.getChildStdIn().flush();
            }
        }
        catch (IOException e) {
            throw new ProblemException((Problems)Problems.caught((Throwable)e));
        }
        catch (RiskscapeException e) {
            throw new ProblemException((Problems)e.getProblem());
        }
    }

    private long readFunctionResponse() throws IOException {
        long rowCount = this.process.getChildStdOut().readLong();
        if (rowCount == -1L) {
            String errorMesssage = (String)Types.TEXT.fromBytes(this.process.getChildStdOut());
            throw new FunctionCallException(Problems.foundWith((Object)this.errorContext, (Problems)CPythonProblems.get().functionCallException(errorMesssage)), null);
        }
        if (rowCount == 0L) {
            this.checkForDynamicOutputs();
            this.outputFinished.set(true);
        }
        return rowCount;
    }

    private boolean isExpectedToProduceOutput() {
        return !this.producedType.equals((Object)Struct.EMPTY_STRUCT);
    }

    private void checkForDynamicOutputs() throws IOException {
        int numOutputs = this.process.getChildStdOut().readInt();
        if (!this.isExpectedToProduceOutput() && numOutputs == 0) {
            this.context.getExecutionContext().getProject().getProblemSink().accept(CPythonProblems.get().noOutput().withSeverity(Problem.Severity.WARNING));
        }
        for (int i = 0; i < numOutputs; ++i) {
            Path outputPath = Paths.get(this.process.getChildStdOut().readUTF(), new String[0]);
            if (Files.isReadable(outputPath)) {
                this.context.getOutputContainer().registerLocalFile(outputPath);
                continue;
            }
            this.context.getExecutionContext().getProject().getProblemSink().accept(CPythonProblems.get().missingOutput(this.script.getLocation(), outputPath));
        }
    }

    @Generated
    public CPythonAsyncProjector(Object errorContext, Struct inputType, Struct producedType, Optional<Tuple> parameters, Resource script, CPythonSpawner processSpawner) {
        this.errorContext = errorContext;
        this.inputType = inputType;
        this.producedType = producedType;
        this.parameters = parameters;
        this.script = script;
        this.processSpawner = processSpawner;
    }

    @Generated
    public Struct getProducedType() {
        return this.producedType;
    }

    @Generated
    CPythonSpawner.CPythonProcess getProcess() {
        return this.process;
    }

    @Generated
    public TupleInput getInput() {
        return this.input;
    }

    @Generated
    public SinkConstructor getOutput() {
        return this.output;
    }
}

