/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import systems.uom.common.USCustomary;
import tech.units.indriya.format.SimpleUnitFormat;

public class UnitUtils {
    public static <T extends Quantity<T>> Unit<T> of(String identifier, Class<T> type) throws RiskscapeException {
        try {
            Unit<?> parsed = UnitUtils.of(identifier);
            try {
                return parsed.asType(type);
            }
            catch (ClassCastException e) {
                throw new RiskscapeException((Problems)LocalProblems.get().wrongType(parsed, type));
            }
        }
        catch (MeasurementParseException e) {
            throw new RiskscapeException((Problems)LocalProblems.get().notRecognised(identifier));
        }
    }

    private static Unit<?> of(String identifier) {
        switch (identifier) {
            case "in": {
                return USCustomary.INCH;
            }
            case "ft": {
                return USCustomary.FOOT;
            }
            case "ft_survey_us": {
                return USCustomary.FOOT_SURVEY;
            }
            case "mi": {
                return USCustomary.MILE;
            }
            case "ha": {
                return USCustomary.HECTARE;
            }
        }
        return SimpleUnitFormat.getInstance().parse((CharSequence)identifier);
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem notRecognised(String var1);

        public <T extends Quantity<T>> Problem wrongType(Unit<?> var1, Class<T> var2);
    }
}

