/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.CsvWriter;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FileUtils;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;

public class StatsWriter {
    private static final Struct TYPE = Struct.of((String)"name", (Type)Types.TEXT, (String)"runtime-ms", (Type)Nullable.INTEGER, (String)"runtime-average-ms", (Type)Nullable.TEXT, (String)"tuples-in", (Type)Nullable.INTEGER, (String)"tuples-in-per-sec", (Type)Nullable.TEXT).and("tuples-out", (Type)Nullable.INTEGER).and("tuples-out-per-sec", (Type)Nullable.TEXT).and("context-switches", (Type)Nullable.INTEGER);
    private static final Comparator<Tuple> RUNTIME_COMPARATOR = (t1, t2) -> {
        Long rt1 = (Long)t1.fetch("runtime-ms");
        Long rt2 = (Long)t2.fetch("runtime-ms");
        return Long.compare(rt2, rt1);
    };
    private final MetricRegistry registry;
    public static final String FILENAME = "model-run-stats.csv";
    public static final String CONTENT_TYPE = "text/csv";

    public void writeStats(Path outputFilepath) {
        FileUtils.rewrite(outputFilepath, out -> this.writeStats((OutputStream)out));
    }

    public void writeStats(OutputStream os) {
        try (CsvWriter writer = new CsvWriter(TYPE, ProblemSink.DEVNULL, new PrintWriter(os));){
            this.stepNames().map(name -> this.stepMetrics((String)name)).sorted(RUNTIME_COMPARATOR).forEachOrdered(t -> writer.write((Tuple)t));
        }
        catch (IOException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    private Stream<String> stepNames() {
        return this.registry.getNames().stream().filter(name -> name.endsWith(".tuples-in") || name.endsWith(".tuples-out")).map(name -> name.substring(0, name.indexOf("."))).distinct().filter(step -> this.registry.getMetrics().containsKey(step + ".runtime"));
    }

    private Tuple stepMetrics(String step) {
        Tuple toWrite = Tuple.ofValues((Struct)TYPE, (Object[])new Object[]{step});
        if (this.registry.getCounters().containsKey(step + ".runtime")) {
            toWrite.set("runtime-ms", (Object)((Counter)this.registry.getCounters().get(step + ".runtime")).getCount());
        }
        if (this.registry.getHistograms().containsKey(step + ".runtime-average")) {
            toWrite.set("runtime-average-ms", (Object)String.format("%.2f", ((Histogram)this.registry.getHistograms().get(step + ".runtime-average")).getSnapshot().getMean()));
        }
        if (this.registry.getMeters().containsKey(step + ".tuples-in")) {
            toWrite.set("tuples-in", (Object)((Meter)this.registry.getMeters().get(step + ".tuples-in")).getCount());
        }
        if (this.registry.getGauges().containsKey(step + ".tuples-in.per-sec")) {
            toWrite.set("tuples-in-per-sec", (Object)String.format("%.2f", ((Gauge)this.registry.getGauges().get(step + ".tuples-in.per-sec")).getValue()));
        }
        if (this.registry.getMeters().containsKey(step + ".tuples-out")) {
            toWrite.set("tuples-out", (Object)((Meter)this.registry.getMeters().get(step + ".tuples-out")).getCount());
        }
        if (this.registry.getGauges().containsKey(step + ".tuples-out.per-sec")) {
            toWrite.set("tuples-out-per-sec", (Object)String.format("%.2f", ((Gauge)this.registry.getGauges().get(step + ".tuples-out.per-sec")).getValue()));
        }
        if (this.registry.getCounters().containsKey(step + ".context-switches")) {
            toWrite.set("context-switches", (Object)((Counter)this.registry.getCounters().get(step + ".context-switches")).getCount());
        }
        return toWrite;
    }

    @Generated
    public StatsWriter(MetricRegistry registry) {
        this.registry = registry;
    }
}

