/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.util.SegmentedList;

final class SegmentedTupleList
extends AbstractList<Tuple> {
    private final Struct struct;
    private final List<? extends List<Object>> memberLists;

    SegmentedTupleList(Struct struct) {
        if (struct.size() == 0) {
            throw new IllegalArgumentException("Can not build a segmented list of empty structs");
        }
        this.struct = struct;
        this.memberLists = struct.getMembers().stream().map(member -> SegmentedList.forType(member.getType())).toList();
    }

    @Override
    public boolean add(Tuple e) {
        assert (e.getStruct().equals((Object)this.struct));
        int index = 0;
        for (List<Object> list : this.memberLists) {
            list.add(e.fetch(index++));
        }
        return true;
    }

    @Override
    public void add(int index, Tuple element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple get(int index) {
        return Tuple.ofValues((Struct)this.struct, (Object[])this.memberLists.stream().map(list -> list.get(index)).toArray());
    }

    @Override
    public Iterator<Tuple> iterator() {
        final List<Iterator> iterators = this.memberLists.stream().map(List::iterator).toList();
        return new Iterator<Tuple>(){

            @Override
            public Tuple next() {
                Tuple tuple = Tuple.of((Struct)SegmentedTupleList.this.struct);
                int index = 0;
                for (Iterator iterator : iterators) {
                    tuple.set(index++, iterator.next());
                }
                return tuple;
            }

            @Override
            public boolean hasNext() {
                return ((Iterator)iterators.get(0)).hasNext();
            }
        };
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> c) {
        if (c instanceof SegmentedTupleList) {
            SegmentedTupleList stl = (SegmentedTupleList)c;
            if (stl.struct == this.struct) {
                for (int i = 0; i < this.memberLists.size(); ++i) {
                    this.memberLists.get(i).addAll((Collection<Object>)stl.memberLists.get(i));
                }
                return true;
            }
        }
        return super.addAll(c);
    }

    @Override
    public int size() {
        return this.memberLists.get(0).size();
    }
}

