/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.SegmentedDoubleList;
import nz.org.riskscape.engine.util.SegmentedFloatList;
import nz.org.riskscape.engine.util.SegmentedLongList;
import nz.org.riskscape.engine.util.SegmentedObjectList;
import nz.org.riskscape.engine.util.SegmentedTupleList;

public abstract class SegmentedList<T>
extends AbstractList<T> {
    private int size;
    private final LinkedList<Object> segments = new LinkedList();
    private int lastSegmentSize = 0;
    private Object lastSegment = new Object[0];
    private final Class<? super T> componentType;

    public static <T> List<T> forClass(Class<T> componentType) {
        assert (componentType != Tuple.class) : "Use forType instead";
        SegmentedList newList = componentType == Double.class ? new SegmentedDoubleList() : (componentType == Float.class ? new SegmentedFloatList() : (componentType == Long.class ? new SegmentedLongList() : new SegmentedObjectList()));
        return newList;
    }

    public static <T> List<T> forType(Type type) {
        Class componentType = type.internalType();
        if (Nullable.is((Type)type)) {
            return new SegmentedObjectList();
        }
        if (type instanceof Struct) {
            Struct struct = (Struct)type;
            return new SegmentedTupleList(struct);
        }
        return SegmentedList.forClass(componentType);
    }

    @Override
    public T get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (this.segments.size() == 1) {
            this.arrayGet(this.lastSegment, index);
        }
        Iterator<T> iter = this.iterator();
        for (int ctr = 0; ctr != index; ++ctr) {
            iter.next();
        }
        return iter.next();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T element) {
        ++this.size;
        if (this.lastSegmentSize == Array.getLength(this.lastSegment)) {
            this.lastSegment = this.newArray(this.nextSegmentSize());
            this.lastSegmentSize = 0;
            this.segments.add(this.lastSegment);
        }
        this.arraySet(this.lastSegment, this.lastSegmentSize++, element);
        return true;
    }

    int nextSegmentSize() {
        return 1 << Math.min(16, 4 + this.segments.size());
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (c instanceof SegmentedList) {
            SegmentedList rhsList = (SegmentedList)c;
            if (rhsList.componentType != this.componentType) {
                throw new ClassCastException("Can not types " + String.valueOf(rhsList.componentType) + " and " + String.valueOf(this.componentType));
            }
            this.fitLastSegmentToSize();
            rhsList.fitLastSegmentToSize();
            for (Object e : rhsList.segments) {
                this.segments.addLast(e);
            }
            this.lastSegment = this.segments.getLast();
            this.lastSegmentSize = Array.getLength(this.lastSegment);
            this.size += rhsList.size;
            return true;
        }
        return super.addAll(c);
    }

    public SegmentedList<T> fold(SegmentedList<T> rhs) {
        this.addAll((Collection<? extends T>)rhs);
        return this;
    }

    int getNumSegments() {
        return this.segments.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.compactArrays();
        this.arraySort(this.lastSegment, c);
    }

    private void fitLastSegmentToSize() {
        if (Array.getLength(this.lastSegment) == this.lastSegmentSize) {
            return;
        }
        Object resizedLastSegment = this.newArray(this.lastSegmentSize);
        System.arraycopy(this.lastSegment, 0, resizedLastSegment, 0, this.lastSegmentSize);
        this.segments.removeLast();
        this.segments.addLast(resizedLastSegment);
        this.lastSegment = resizedLastSegment;
    }

    protected abstract Object newArray(int var1);

    protected abstract void arraySet(Object var1, int var2, T var3);

    protected abstract T arrayGet(Object var1, int var2);

    protected abstract void arraySort(Object var1, Comparator<? super T> var2);

    private void compactArrays() {
        Object newArray = this.newArray(this.size);
        int counter = 0;
        int remaining = this.size;
        Iterator iter = this.segments.iterator();
        while (iter.hasNext()) {
            Object segment = iter.next();
            iter.remove();
            int segmentLength = Array.getLength(segment);
            System.arraycopy(segment, 0, newArray, counter, Math.min(segmentLength, remaining));
            counter += segmentLength;
            remaining -= segmentLength;
        }
        this.lastSegment = newArray;
        this.lastSegmentSize = this.size;
        this.segments.add(this.lastSegment);
    }

    @Generated
    SegmentedList(Class<? super T> componentType) {
        this.componentType = componentType;
    }

    class Iter
    implements Iterator<T> {
        private final int size;
        private Iterator<Object> segmentIter;
        private Object segment = new Object[0];
        private int counter = 0;
        private int segmentCounter = 0;

        Iter() {
            this.segmentIter = SegmentedList.this.segments.iterator();
            this.size = SegmentedList.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.size;
        }

        @Override
        public T next() {
            if (this.counter >= this.size) {
                throw new NoSuchElementException();
            }
            if (this.segmentCounter >= Array.getLength(this.segment)) {
                this.segment = this.segmentIter.next();
                this.segmentCounter = 0;
            }
            ++this.counter;
            return SegmentedList.this.arrayGet(this.segment, this.segmentCounter++);
        }
    }
}

