/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import nz.org.riskscape.engine.util.PercentGauge;

public abstract class ProgressNotifier {
    public static final long INITIAL_DELAY = 200L;
    public static final long UPDATE_INTERVAL = 100L;
    private final MetricRegistry metrics;
    private final ScheduledExecutorService executor;

    protected abstract void updateStatus();

    public ProgressNotifier(MetricRegistry metrics, long initialDelayMs, long updateIntervalMs) {
        this.metrics = metrics;
        this.executor = new ScheduledThreadPoolExecutor(1, runnable -> new Thread(runnable, "PipelineProgressMonitor"));
        this.executor.scheduleAtFixedRate(new Updater(), initialDelayMs, updateIntervalMs, TimeUnit.MILLISECONDS);
    }

    public ProgressNotifier(MetricRegistry metrics) {
        this(metrics, 200L, 100L);
    }

    protected List<String> buildUpdateMessage() {
        PercentGauge gauge;
        Metric metric;
        ArrayList<String> statusLines = new ArrayList<String>();
        for (String metricName : this.metrics.getNames()) {
            metric = (Metric)this.metrics.getMetrics().get(metricName);
            if (!(metric instanceof PercentGauge) || !(gauge = (PercentGauge)metric).hasValue()) continue;
            statusLines.add(String.format("%8d / %8d     %6.2f%%  %s", gauge.getNumerator(), gauge.getDenominator(), gauge.getValue(), metricName));
        }
        for (String metricName : this.metrics.getNames()) {
            Counting count;
            metric = (Metric)this.metrics.getMetrics().get(metricName);
            if (!(metric instanceof Counting) || (count = (Counting)metric).getCount() == 0L) continue;
            String toPrint = String.format("%2$31d: %1$s", metricName, count.getCount());
            if (metric instanceof Metered) {
                Metered meter = (Metered)metric;
                toPrint = String.format("%2$8d total, %3$9.3f/s avg: %1$5s", metricName, meter.getCount(), meter.getOneMinuteRate());
            }
            statusLines.add(toPrint);
        }
        for (String metricName : this.metrics.getNames()) {
            metric = (Metric)this.metrics.getMetrics().get(metricName);
            if (metric instanceof PercentGauge || !(metric instanceof Gauge)) continue;
            gauge = (Gauge)metric;
            statusLines.add(String.format("%2$31s: %1s", metricName, gauge.getValue()));
        }
        return statusLines;
    }

    public void finish() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class Updater
    implements Runnable {
        private Updater() {
        }

        @Override
        public void run() {
            ProgressNotifier.this.updateStatus();
        }
    }
}

