/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WithinSet;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class FunctionCallOptions {
    public static final String OPTIONS_ARG_NAME = "options";
    public static final CaseFormat OPTONS_NAME_CASE = CaseFormat.LOWER_UNDERSCORE;

    public static <T> FunctionArgument options(Class<T> optionsClass) {
        return FunctionCallOptions.options(OPTIONS_ARG_NAME, optionsClass);
    }

    public static <T> FunctionArgument options(String optionsArgName, Class<T> optionsClass) {
        return new FunctionArgument(optionsArgName, (Type)FunctionCallOptions.optionsToStruct(optionsClass));
    }

    public static <T> Struct optionsToStruct(Class<T> optionsClass) {
        Struct.StructBuilder builder = Struct.builder();
        JavaParameterSet<T> parameterSet = JavaParameterSet.fromBindingClass(optionsClass, OPTONS_NAME_CASE);
        for (Parameter param : parameterSet.getDeclared()) {
            Class parameterType = param.getType();
            Object type = parameterType.isEnum() ? WithinSet.fromEnum((Class)parameterType) : (parameterType == Object.class ? Types.ANYTHING : (Type)Types.fromJavaTypeOptional((Class)parameterType).get());
            if (param.isMany()) {
                type = RSList.create((Type)type);
            }
            builder.add(param.getName(), (Type)type);
        }
        return builder.build();
    }

    public static Optional<ResultOrProblems<Tuple>> bindTuple(RealizationContext context, ArgumentList argList, FunctionCall functionCall) {
        return FunctionCallOptions.bindTuple(OPTIONS_ARG_NAME, context, argList, functionCall);
    }

    public static Optional<ResultOrProblems<Tuple>> bindTuple(String optionsArgName, RealizationContext context, ArgumentList argList, FunctionCall functionCall) {
        if (!argList.hasArgument(optionsArgName)) {
            throw new RuntimeException("cannot bindOptions when argList has no options");
        }
        return argList.getArgument(functionCall, optionsArgName).map(arg -> arg.evaluateConstant(context, Tuple.class, argList.get(optionsArgName).getType()));
    }

    public static <T> ResultOrProblems<T> bindOptions(Class<T> optionsClass, RealizationContext context, ArgumentList argList, FunctionCall functionCall) {
        return FunctionCallOptions.bindOptions(OPTIONS_ARG_NAME, optionsClass, context, argList, functionCall);
    }

    public static <T> ResultOrProblems<T> bindOptions(String optionsArgName, Class<T> optionsClass, RealizationContext context, ArgumentList argList, FunctionCall functionCall) {
        JavaParameterSet parameterSet = JavaParameterSet.fromBindingClass(optionsClass, OPTONS_NAME_CASE);
        HashMap values = new HashMap();
        return FunctionCallOptions.bindTuple(optionsArgName, context, argList, functionCall).map(t -> t.flatMap(tuple -> {
            tuple.toMap().entrySet().forEach(entry -> {
                Object patt6684$temp = entry.getValue();
                if (patt6684$temp instanceof List) {
                    List list = (List)patt6684$temp;
                    values.put((String)entry.getKey(), list);
                } else {
                    values.put((String)entry.getKey(), List.of(entry.getValue()));
                }
            });
            return parameterSet.bindToObject(context.getProject().newBindingContext(context), values).flatMap(bound -> {
                if (!bound.getExtraneous().isEmpty()) {
                    ArrayList problems = new ArrayList();
                    List possible = FunctionCallOptions.optionsToStruct(optionsClass).getMemberKeys();
                    bound.getExtraneous().keySet().stream().forEach(key -> problems.add(GeneralProblems.get().notAnOption(key, (Object)OPTIONS_ARG_NAME, possible)));
                    return ResultOrProblems.failed(problems);
                }
                return ResultOrProblems.of(bound.getBoundToObject());
            });
        })).orElseGet(() -> parameterSet.bindToObject(context.getProject().newBindingContext(context), values).map(bound -> bound.getBoundToObject()));
    }

    public static <T> T bindOptionsOrThrow(Class<T> optionsClass, RealizationContext context, ArgumentList argList, FunctionCall functionCall) throws ProblemException {
        return (T)FunctionCallOptions.bindOptions(optionsClass, context, argList, functionCall).getOrThrow(problems -> Problems.foundWith((Object)OPTIONS_ARG_NAME, (Problems)problems));
    }
}

