/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class FileUtils {
    public static void rewrite(Path outputFilepath, Consumer<PrintStream> writer) {
        PrintStream out;
        File tmpFile = new File(outputFilepath.toString() + ".tmp");
        try {
            out = new PrintStream(tmpFile);
        }
        catch (FileNotFoundException e) {
            throw new RiskscapeIOException(FileUtils.writeError(tmpFile.toPath(), e));
        }
        writer.accept(out);
        out.close();
        try {
            Files.move(tmpFile.toPath(), outputFilepath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RiskscapeIOException(FileUtils.writeError(outputFilepath, e));
        }
    }

    public static void removeDirectory(Path directory) throws IOException {
        FileUtils.cleanDirectory(directory, path -> true);
    }

    public static void cleanDirectory(Path directory) throws IOException {
        FileUtils.cleanDirectory(directory, path -> !path.equals(directory));
    }

    private static void cleanDirectory(Path directory, Predicate<Path> filter) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + directory.toString());
        }
        Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(filter).map(Path::toFile).forEach(File::delete);
    }

    private static Problem writeError(Path filepath, Exception ex) {
        return ((FileProblems)Problems.get(FileProblems.class)).cantWriteTo(filepath).withChildren(new Problems[]{Problems.caught((Throwable)ex)});
    }
}

