/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import com.codahale.metrics.MetricRegistry;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.util.FileUtils;
import nz.org.riskscape.engine.util.ProgressNotifier;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProgressNotifier
extends ProgressNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileProgressNotifier.class);
    public static final long INITIAL_DELAY = 1000L;
    public static final long UPDATE_INTERVAL = 1000L;
    private final Path outputPath;
    private final ProblemSink problemSink;
    private boolean problemLogged = false;

    public FileProgressNotifier(MetricRegistry metrics, Path outputPath, ProblemSink sink) {
        this(metrics, outputPath, sink, 1000L, 1000L);
    }

    protected FileProgressNotifier(MetricRegistry metrics, Path outputPath, ProblemSink sink, long initialDelayMs, long updateIntervalMs) {
        super(metrics, initialDelayMs, updateIntervalMs);
        this.outputPath = outputPath;
        this.problemSink = sink;
    }

    @Override
    protected void updateStatus() {
        this.writeFile(out -> out.println(String.join((CharSequence)OsUtils.LINE_SEPARATOR, this.buildUpdateMessage())));
    }

    @Override
    public void finish() {
        super.finish();
        this.writeFile(out -> {
            out.println(String.join((CharSequence)OsUtils.LINE_SEPARATOR, this.buildUpdateMessage()));
            out.println("Complete!");
        });
    }

    private void writeFile(Consumer<PrintStream> writer) {
        block2: {
            try {
                FileUtils.rewrite(this.outputPath, writer);
            }
            catch (RiskscapeIOException ex) {
                if (this.problemLogged) break block2;
                this.problemSink.log(Problems.caught((Throwable)ex).withSeverity(Problem.Severity.WARNING));
                this.problemLogged = true;
            }
        }
    }
}

