/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;
import nz.org.riskscape.rl.TokenTypes;

public class UriHelper {
    public static final Pattern PROTO_ISH = Pattern.compile("^[a-z]{2,}:");
    public static final String FILE_SCHEME = "file";
    private static final Escaper URI_ESCAPER = UrlEscapers.urlFragmentEscaper();

    public static ResultOrProblems<URI> uriFromLocation(String location, URI relativeTo) {
        relativeTo = UriHelper.removeFragment(relativeTo);
        if (UriHelper.hasUriScheme(location)) {
            try {
                return ResultOrProblems.of((Object)new URI(location.replace(" ", "%20")));
            }
            catch (URISyntaxException e) {
                return UriHelper.uriProblem(location, e);
            }
        }
        if (!UriHelper.isFile(relativeTo)) {
            try {
                return ResultOrProblems.of((Object)relativeTo.resolve(URI_ESCAPER.escape(location)));
            }
            catch (IllegalArgumentException ex) {
                return UriHelper.uriProblem(location, ex.getCause());
            }
        }
        Path relative = Paths.get(relativeTo);
        if (!relative.toFile().isDirectory()) {
            relative = relative.getParent();
        }
        location = location.replaceAll("/", Matcher.quoteReplacement(File.separator));
        URI locationURI = relative.resolve(location).toUri().normalize();
        if (location.endsWith(File.separator) && !locationURI.toString().endsWith("/")) {
            try {
                locationURI = new URI(locationURI.toString() + "/");
            }
            catch (URISyntaxException ex) {
                return UriHelper.uriProblem(locationURI.toString() + "/", ex);
            }
        }
        return ResultOrProblems.of((Object)locationURI);
    }

    private static URI removeFragment(URI relativeTo) {
        if (!relativeTo.getScheme().equals(FILE_SCHEME)) {
            return relativeTo;
        }
        if (Strings.isNullOrEmpty((String)relativeTo.getFragment())) {
            return relativeTo;
        }
        String uriString = relativeTo.toString();
        int lastIndexOf = uriString.lastIndexOf(35);
        if (lastIndexOf > 0) {
            return URI.create(uriString.substring(0, lastIndexOf));
        }
        return relativeTo;
    }

    public static ResultOrProblems<URI> directoryUriFromLocation(String location, URI relativeTo) {
        return UriHelper.uriFromLocation((String)(location.endsWith("/") || location.endsWith(File.separator) ? location : location + "/"), relativeTo);
    }

    public static String makeRelativeToIfDotSlash(String location, URI relativeTo) {
        ResultOrProblems<URI> uri;
        String unquoted = TokenTypes.stripQuotes((String)location);
        if (unquoted.startsWith("./") && !(uri = UriHelper.uriFromLocation(unquoted, relativeTo)).hasProblems()) {
            return ((URI)uri.get()).toString();
        }
        return location;
    }

    private static ResultOrProblems<URI> uriProblem(String location, Throwable uriException) {
        ProblemPlaceholder uriContext = ProblemPlaceholder.of(URI.class, (String)location);
        return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)StandardCodes.INVALID_BECAUSE, (Object[])new Object[]{uriContext, uriException.getMessage()}).withException(uriException).affecting((Object)uriContext)});
    }

    public static boolean isFile(URI uri) {
        return FILE_SCHEME.equals(uri.getScheme());
    }

    public static boolean hasUriScheme(String location) {
        return PROTO_ISH.matcher(location).find();
    }
}

