/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.BaseResource;

public class StringResource
extends BaseResource {
    private static final char ELLIPSIS = '\u2026';
    private final String content;

    public static StringResource fromConfig(ConfigString config) {
        return new StringResource(config.getLocation(), config.toString());
    }

    public static StringResource internal(String fixedName, String content) {
        try {
            return new StringResource(fixedName, content);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)String.format("'%s' is not a valid URI: %s", fixedName, ex.toString()));
        }
    }

    public StringResource(URI location, String content) {
        super(location);
        this.content = content;
    }

    public StringResource(String location, String content) throws URISyntaxException {
        this(new URI(location), content);
    }

    public StringResource(String location, String ... contentLines) throws URISyntaxException {
        this(location, Arrays.asList(contentLines).stream().collect(Collectors.joining(OsUtils.LINE_SEPARATOR)));
    }

    public InputStream getContentStream() throws RiskscapeIOException {
        return new ByteArrayInputStream(this.content.getBytes());
    }

    public String toString() {
        Object displayResource = this.content;
        if (((String)displayResource).length() > 20) {
            displayResource = ((String)displayResource).substring(0, 20) + "\u2026";
        }
        return String.format("StringResource(%s)", displayResource);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringResource)) {
            return false;
        }
        StringResource other = (StringResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$content = this.content;
        String other$content = other.content;
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

