/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.ResourceProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class FileResource
implements Resource {
    private final Path filePath;

    public static FileResource load(URI target) throws ResourceLoadingException {
        if (!target.getScheme().equals("file")) {
            throw new ResourceLoadingException(target, String.format("%s is not a file resource", target));
        }
        Path targetPath = Paths.get(target);
        if (!targetPath.toFile().exists()) {
            throw new ResourceLoadingException(target, ResourceProblems.get().notFound(target, new Problem[0]));
        }
        if (!targetPath.toFile().canRead()) {
            throw new ResourceLoadingException(target, ResourceProblems.get().readAccessDenied(target));
        }
        return new FileResource(targetPath);
    }

    public URI getLocation() {
        return this.filePath.toUri();
    }

    public InputStream getContentStream() throws RiskscapeIOException {
        try {
            return new FileInputStream(this.filePath.toFile());
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Could get input stream from resource " + this.getLocation().toString(), (Exception)e);
        }
    }

    public String toString() {
        return String.format("FileResource(%s)", this.filePath.toString());
    }

    public ResultOrProblems<Path> ensureLocal(Resource.Options options, String extension) {
        return ResultOrProblems.of((Object)this.filePath);
    }

    public Optional<Path> getLocal() {
        return Optional.of(this.filePath);
    }

    @Generated
    public FileResource(Path filePath) {
        this.filePath = filePath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileResource)) {
            return false;
        }
        FileResource other = (FileResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$filePath = this.getFilePath();
        Path other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !((Object)this$filePath).equals(other$filePath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : ((Object)$filePath).hashCode());
        return result;
    }

    @Generated
    public Path getFilePath() {
        return this.filePath;
    }
}

