/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class ZipRelation
extends BaseRelation {
    private final List<BaseRelation> relations;
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    private static Struct buildType(List<BaseRelation> underlyingRelations) {
        Struct struct = Struct.EMPTY_STRUCT;
        for (BaseRelation relation : underlyingRelations) {
            struct = struct.and(relation.getType());
        }
        return struct;
    }

    private static List<Long> distinctSizes(List<BaseRelation> toCheck) {
        return toCheck.stream().filter(r -> r.size().isPresent()).map(r -> (Long)r.size().get()).distinct().collect(Collectors.toList());
    }

    public ZipRelation(List<BaseRelation> relations) {
        super(ZipRelation.buildType(relations));
        if (ZipRelation.distinctSizes(relations).size() > 1) {
            throw new RiskscapeIOException(PROBLEMS.mismatchingRows());
        }
        this.relations = relations;
    }

    public ZipRelation(BaseRelation ... relations) {
        this(Arrays.asList(relations));
    }

    protected ZipRelation(BaseRelation.Fields fields, List<BaseRelation> relations) {
        super(fields);
        this.relations = relations;
    }

    @Override
    protected TupleIterator rawIterator() {
        final ArrayList<TupleIterator> iterators = new ArrayList<TupleIterator>();
        for (BaseRelation relation : this.relations) {
            iterators.add(relation.rawIterator());
        }
        return new TupleIterator(){

            public boolean hasNext() {
                boolean allHaveNext = iterators.stream().map(iter -> iter.hasNext()).allMatch(b -> b);
                boolean anyHasNext = iterators.stream().map(iter -> iter.hasNext()).anyMatch(b -> b);
                if (anyHasNext != allHaveNext) {
                    throw new RiskscapeIOException(PROBLEMS.mismatchingRows());
                }
                return allHaveNext;
            }

            public Tuple next() {
                HashMap<String, Object> rawValues = new HashMap<String, Object>();
                for (TupleIterator iter : iterators) {
                    Tuple tuple = (Tuple)iter.next();
                    for (String attrName : tuple.getStruct().getMemberKeys()) {
                        rawValues.put(attrName, tuple.fetch(attrName));
                    }
                }
                return Tuple.coerce((Struct)ZipRelation.this.getRawType(), rawValues);
            }

            public void close() {
                iterators.forEach(iter -> iter.close());
            }
        };
    }

    @Override
    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new ZipRelation(fields, this.relations);
    }

    public String getSourceInformation() {
        return "Zip[" + this.relations.stream().map(r -> r.getSourceInformation()).collect(Collectors.joining(", ")) + "]";
    }

    public Optional<Long> size() {
        List<Long> distinctSizes = ZipRelation.distinctSizes(this.relations);
        if (distinctSizes.size() != 1 || this.relations.stream().anyMatch(r -> !r.size().isPresent())) {
            return Optional.empty();
        }
        return Optional.of(distinctSizes.get(0));
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem mismatchingRows();
    }
}

