/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.relation.UnionIterator;
import nz.org.riskscape.engine.types.Struct;

public class UnionRelation
extends BaseRelation {
    private final List<Relation> relations;

    public UnionRelation(Relation first, Relation ... rest) {
        super(first.getType());
        this.relations = new ArrayList<Relation>(rest.length + 1);
        this.relations.add(first);
        int i = 0;
        while (i < rest.length) {
            this.relations.add(rest[i++]);
        }
    }

    public UnionRelation(Struct type, List<Relation> relations) {
        super(type);
        this.relations = relations;
    }

    public UnionRelation(BaseRelation.Fields fields, List<Relation> relations) {
        super(fields);
        this.relations = relations;
    }

    public String getSourceInformation() {
        return String.format("Union of %s... (size: %d)", this.relations.get(0), this.relations.size());
    }

    @Override
    protected TupleIterator rawIterator() {
        return new UnionIterator(Lists.transform(this.relations, src -> src.iterator()).iterator());
    }

    @Override
    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new UnionRelation(fields, this.relations);
    }

    @Generated
    public List<Relation> getRelations() {
        return this.relations;
    }
}

