/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.codahale.metrics.Timer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.PeekingTupleIterator;
import nz.org.riskscape.engine.relation.TupleIterator;

public class TupleIterators {
    public static TupleIterator peeker(final Supplier<Tuple> supplier, Optional<Runnable> onClose) {
        return new PeekingTupleIterator(onClose){

            @Override
            protected Tuple get() {
                return (Tuple)supplier.get();
            }

            @Override
            protected String getSource() {
                return supplier.toString();
            }
        };
    }

    public static TupleIterator timed(Timer timer, TupleIterator iterator) {
        return TupleIterators.timed(timer, iterator, null);
    }

    public static TupleIterator timed(final Timer timer, final TupleIterator iterator, final Runnable onClose) {
        return new TupleIterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Tuple next() {
                long nanos = System.nanoTime();
                try {
                    Tuple tuple = (Tuple)iterator.next();
                    return tuple;
                }
                finally {
                    timer.update(System.nanoTime() - nanos, TimeUnit.NANOSECONDS);
                }
            }

            public void close() {
                if (onClose != null) {
                    onClose.run();
                }
                iterator.close();
            }
        };
    }
}

