/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.TupleIterator;

public abstract class PeekingTupleIterator
implements TupleIterator {
    private final Optional<Runnable> onClose;
    private Tuple peeked;
    private InvalidTupleException caughtWhilePeeking;

    protected PeekingTupleIterator() {
        this(Optional.empty());
    }

    public boolean hasNext() {
        return this.peek(false);
    }

    public final Tuple next() {
        this.peek(true);
        Tuple toReturn = this.peeked;
        if (toReturn == null) {
            throw new NoSuchElementException();
        }
        this.peeked = null;
        return toReturn;
    }

    public void close() {
        this.onClose.ifPresent(Runnable::run);
    }

    private boolean peek(boolean throwPeeked) {
        if (throwPeeked && this.caughtWhilePeeking != null) {
            InvalidTupleException toThrow = this.caughtWhilePeeking;
            this.caughtWhilePeeking = null;
            throw toThrow;
        }
        if (this.caughtWhilePeeking != null) {
            return true;
        }
        if (this.peeked == null) {
            try {
                this.peeked = this.get();
            }
            catch (InvalidTupleException e) {
                if (throwPeeked) {
                    throw e;
                }
                this.caughtWhilePeeking = e;
                return true;
            }
        }
        return this.peeked != null;
    }

    protected abstract Tuple get();

    protected abstract String getSource();

    public String toString() {
        return String.format("Peeking(%s)", this.getSource());
    }

    @Generated
    public PeekingTupleIterator(Optional<Runnable> onClose) {
        this.onClose = onClose;
    }
}

