/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;

public class ListRelation
extends BaseRelation {
    @NonNull
    private final List<Tuple> source;

    public static ListRelation ofValues(Object ... rest) {
        Type type = (Type)Types.fromJavaTypeOptional(rest[0].getClass()).get();
        Struct struct = type.asStruct();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(rest.length);
        for (int i = 0; i < rest.length; ++i) {
            Object object = rest[i];
            tuples.add(Tuple.ofValues((Struct)struct, (Object[])new Object[]{type.coerce(object)}));
        }
        return new ListRelation(tuples);
    }

    public static ListRelation ofTypedValues(Struct struct, Object ... rest) {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(rest.length);
        for (int i = 0; i < rest.length; ++i) {
            Object object = rest[i];
            tuples.add(Tuple.ofValues((Struct)struct, (Object[])new Object[]{object}));
        }
        return new ListRelation(tuples);
    }

    public ListRelation(Struct type, List<Tuple> source, SpatialMetadata spatialMetadata) {
        super(type, null, spatialMetadata);
        this.source = source;
    }

    public ListRelation(Struct type, List<Tuple> values) {
        this(type, values, null);
    }

    public ListRelation(List<Tuple> values) {
        this(values.get(0).getStruct(), values, null);
    }

    public ListRelation(Tuple first, Tuple ... rest) {
        this(first.getStruct(), (List<Tuple>)ImmutableList.builder().add((Object)first).addAll(Arrays.asList(rest)).build());
    }

    public ListRelation(Struct type, Tuple ... values) {
        this(type, Arrays.asList(values), null);
    }

    protected ListRelation(BaseRelation.Fields fields, List<Tuple> source) {
        super(fields);
        this.source = source;
    }

    @Override
    public TupleIterator rawIterator() {
        return TupleIterator.wrapped(this.source.iterator(), Optional.empty());
    }

    public List<Tuple> getList() {
        return this.source;
    }

    @Override
    public String toString() {
        return String.format("List[size:%d]", this.source.size());
    }

    public String getSourceInformation() {
        return this.toString();
    }

    @Override
    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new ListRelation(fields, this.source);
    }

    public ListRelation inferSpatialMetadata(Project project) {
        Struct.StructMember geomMember = TupleUtils.findRequiredGeometryMember((Struct)this.getType());
        CoordinateReferenceSystem crs = this.source.size() > 0 ? project.getSridSet().get((Geometry)this.source.get(0).fetch(geomMember)) : project.getDefaultCrs();
        return this.withSpatialMetadata(new SpatialMetadata(crs, geomMember));
    }

    public ListRelation withSpatialMetadata(SpatialMetadata newSpatialMetadata) {
        return new ListRelation(new BaseRelation.Fields().tap(f -> {
            f.spatialMetadata = newSpatialMetadata;
        }), this.source);
    }

    public Optional<Long> size() {
        return Optional.of(Long.valueOf(this.source.size()));
    }
}

