/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.InputDataProblems;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.relation.TupleIterators;
import nz.org.riskscape.engine.restriction.Restriction;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseRelation
implements Relation {
    private final Struct type;
    protected final Transformer[] transformers;
    public final ProblemSink skipOnInvalid;
    private final SpatialMetadata spatialMetadata;
    private final long limit;
    private final long offset;

    public BaseRelation(Fields fields) {
        this.type = fields.type;
        this.transformers = fields.transformers.toArray(new Transformer[0]);
        this.skipOnInvalid = fields.skipOnInvalid;
        this.spatialMetadata = fields.spatialMetadata;
        this.limit = fields.limit;
        this.offset = fields.offset;
    }

    public BaseRelation(Struct type) {
        this(type, null);
    }

    public BaseRelation(Struct type, ProblemSink skipOnInvalid) {
        this.type = type;
        this.transformers = new Transformer[0];
        this.skipOnInvalid = skipOnInvalid;
        this.spatialMetadata = null;
        this.limit = Long.MAX_VALUE;
        this.offset = 0L;
    }

    public BaseRelation(Struct type, ProblemSink skipOnInvalid, SpatialMetadata spatialMetadata) {
        this.type = type;
        this.transformers = new Transformer[0];
        this.skipOnInvalid = skipOnInvalid;
        this.spatialMetadata = spatialMetadata;
        this.limit = Long.MAX_VALUE;
        this.offset = 0L;
    }

    public final TupleIterator iterator() {
        TupleIterator rawIterator = this.rawIterator();
        if (this.transformers.length == 0 && this.skipOnInvalid == null) {
            if (this.offset != 0L || this.limit != Long.MAX_VALUE) {
                return TupleIterators.peeker(new TransformationSupplier(rawIterator), Optional.of(() -> rawIterator.close()));
            }
            return rawIterator;
        }
        return TupleIterators.peeker(new TransformationSupplier(rawIterator), Optional.of(() -> rawIterator.close()));
    }

    protected void skipOrThrow(InvalidTupleException ex) {
        if (this.skipOnInvalid == null) {
            throw ex;
        }
        this.skipOnInvalid.log(InputDataProblems.get().invalidTupleSkipped().withChildren(new Problems[]{ex.getReason()}));
    }

    protected abstract TupleIterator rawIterator();

    protected abstract BaseRelation clone(Fields var1);

    public final ResultOrProblems<Relation> project(Projection projection) {
        ResultOrProblems projector = projection.getProjectionFunction(this.getType());
        if (projector.hasErrors()) {
            return ResultOrProblems.failed((List)projector.getProblems());
        }
        BaseRelation clonedNatively = this.cloneWithProjectionIfSupported(projection);
        if (clonedNatively != null) {
            return ResultOrProblems.of((Object)clonedNatively);
        }
        return ResultOrProblems.of((Object)this.cloneWithTransformer(new Transformer(this.getType(), projection, (Projector)projector.get())), (List)projector.getProblems());
    }

    protected BaseRelation cloneWithTransformer(Transformer transformer) {
        Fields fields = new Fields();
        if (transformer.projectionFunction != null && transformer.projectionFunction.getSpatialMetadataMapper().isPresent()) {
            Function smMapper = (Function)transformer.projectionFunction.getSpatialMetadataMapper().get();
            fields.spatialMetadata = (SpatialMetadata)smMapper.apply(fields.spatialMetadata);
        }
        fields.append(transformer);
        return this.clone(fields);
    }

    protected BaseRelation cloneWithProjectionIfSupported(Projection projection) {
        return null;
    }

    protected BaseRelation cloneWithRestrictionIfSupported(Restriction restriction) {
        return null;
    }

    public final ResultOrProblems<Relation> restrict(Restriction restriction) {
        List problems = restriction.validate(this.getType());
        if (!problems.isEmpty()) {
            return ResultOrProblems.failed((List)problems);
        }
        BaseRelation clonedNatively = this.cloneWithRestrictionIfSupported(restriction);
        if (clonedNatively != null) {
            return ResultOrProblems.of((Object)clonedNatively);
        }
        return ResultOrProblems.of((Object)this.cloneWithTransformer(new Transformer(this.getType(), restriction)));
    }

    public final Optional<SpatialMetadata> getSpatialMetadata() {
        return Optional.ofNullable(this.spatialMetadata);
    }

    public Struct getRawType() {
        return this.type;
    }

    public Struct getProducedType() {
        if (this.transformers.length == 0) {
            return this.type;
        }
        return this.transformers[this.transformers.length - 1].getType();
    }

    public Relation limitAndOffset(long newLimit, long newOffset) {
        Fields fields = new Fields();
        fields.limit = newLimit;
        fields.offset = newOffset;
        return this.clone(fields);
    }

    public Relation skipInvalid(ProblemSink sink) {
        return this.clone(new Fields().tap(f -> {
            f.skipOnInvalid = sink;
        }));
    }

    public String toString() {
        return String.format("%s", this.getClass().getSimpleName());
    }

    public boolean hasSkipOnInvalid() {
        return this.skipOnInvalid != null;
    }

    @Generated
    public BaseRelation(Struct type, Transformer[] transformers, ProblemSink skipOnInvalid, SpatialMetadata spatialMetadata, long limit, long offset) {
        this.type = type;
        this.transformers = transformers;
        this.skipOnInvalid = skipOnInvalid;
        this.spatialMetadata = spatialMetadata;
        this.limit = limit;
        this.offset = offset;
    }

    @Generated
    public long getLimit() {
        return this.limit;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    protected final class Fields {
        Struct type;
        List<Transformer> transformers;
        ProblemSink skipOnInvalid;
        SpatialMetadata spatialMetadata;
        long limit;
        long offset;

        public Fields() {
            this.type = BaseRelation.this.type;
            this.transformers = Lists.newArrayList((Object[])BaseRelation.this.transformers);
            this.skipOnInvalid = BaseRelation.this.skipOnInvalid;
            this.spatialMetadata = BaseRelation.this.spatialMetadata;
            this.limit = BaseRelation.this.limit;
            this.offset = BaseRelation.this.offset;
        }

        public Fields tap(Consumer<Fields> consumer) {
            consumer.accept(this);
            return this;
        }

        Fields append(Transformer transformer) {
            this.transformers.add(transformer);
            return this;
        }
    }

    protected final class Transformer {
        Projection projection;
        Projector projectionFunction;
        Restriction restriction;
        Struct transformedType;

        Transformer(Struct previousType, Projection projection, Projector projectionFunction) {
            this.projection = projection;
            this.projectionFunction = projectionFunction;
            this.transformedType = projectionFunction.getProjectedType();
        }

        Transformer(Struct previousType, Restriction restriction) {
            this.restriction = restriction;
            this.transformedType = previousType;
        }

        Struct getType() {
            return this.transformedType;
        }

        Tuple apply(Tuple tuple) {
            if (this.projection != null) {
                return (Tuple)this.projectionFunction.apply((Object)tuple);
            }
            return this.restriction.getPredicate().test(tuple) ? tuple : null;
        }
    }

    private class TransformationSupplier
    implements Supplier<Tuple> {
        final TupleIterator rawIterator;
        long skipCounter;
        long stopAtZero;

        @Override
        public Tuple get() {
            if (this.stopAtZero == 0L) {
                return null;
            }
            block4: while (this.rawIterator.hasNext()) {
                Tuple raw;
                try {
                    raw = (Tuple)this.rawIterator.next();
                }
                catch (InvalidTupleException ex) {
                    BaseRelation.this.skipOrThrow(ex);
                    continue;
                }
                for (int i = 0; i < BaseRelation.this.transformers.length; ++i) {
                    Transformer t = BaseRelation.this.transformers[i];
                    try {
                        raw = t.apply(raw);
                    }
                    catch (InvalidTupleException ex) {
                        BaseRelation.this.skipOrThrow(ex);
                        continue block4;
                    }
                    if (raw == null) break;
                }
                if (raw == null) continue;
                if (this.skipCounter != 0L) {
                    --this.skipCounter;
                    continue;
                }
                --this.stopAtZero;
                return raw;
            }
            return null;
        }

        @Generated
        public TransformationSupplier(TupleIterator rawIterator) {
            this.skipCounter = BaseRelation.this.offset;
            this.stopAtZero = BaseRelation.this.limit;
            this.rawIterator = rawIterator;
        }
    }
}

