/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class CsvWriter
extends RiskscapeWriter
implements AutoCloseable {
    public static final char BOM = '\ufeff';
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    public static final int COLUMN_MAX_CHARACTERS = Short.MAX_VALUE;
    private Pattern naughtyCharacter = Pattern.compile("[\\n,\"]");
    private static final char[] SEPARATOR = ",".toCharArray();
    private static final char[] LINE_SEPARATOR = String.format("%n", new Object[0]).toCharArray();
    private static final int MAX_WARNINGS = 100;
    private final Struct type;
    private final CreateHandle handle;
    private final boolean includeBom;
    private final Writer writer;
    private boolean headerWritten = false;
    private WKTWriter wktWriter = new WKTWriter();
    private int truncationWarningsGiven = 0;
    private long rowNumber = 1L;
    private ProblemSink sink;
    private URI storedAt = null;

    public CsvWriter(Struct type, ProblemSink problemSink, CreateHandle handle, boolean includeBom) {
        this.type = type;
        this.sink = problemSink;
        this.handle = handle;
        this.writer = new OutputStreamWriter(handle.getOutputStream(), StandardCharsets.UTF_8);
        this.includeBom = includeBom;
    }

    public CsvWriter(Struct type, ProblemSink problemSink, Writer writer) {
        this.type = type;
        this.sink = problemSink;
        this.handle = null;
        this.writer = writer;
        this.includeBom = true;
    }

    @Override
    public void close() throws IOException {
        this.writeHeaderIfNecessary();
        this.writer.close();
        this.storedAt = this.handle != null ? this.handle.store() : null;
    }

    public void write(@NonNull Tuple value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            this.writeHeaderIfNecessary();
            this.write(this.type, value, true);
            this.writer.write(LINE_SEPARATOR);
        }
        catch (IOException e) {
            throw new RiskscapeException("I/O error writing tuples to csv", (Throwable)e);
        }
    }

    protected boolean write(Struct struct, Tuple value, boolean first) throws IOException {
        List members = struct.getMembers();
        for (Struct.StructMember member : members) {
            Object toWrite;
            Type unwrappedType = Nullable.unwrap((Type)member.getType());
            if (unwrappedType instanceof Struct) {
                Tuple child = value == null ? null : (Tuple)value.fetch(member);
                first = this.write((Struct)unwrappedType, child, first);
                continue;
            }
            Object object = toWrite = value == null ? null : value.fetch(member);
            if (!first) {
                this.writer.write(SEPARATOR);
            }
            if (toWrite != null) {
                String toWriteStr;
                if (unwrappedType instanceof Geom) {
                    toWrite = this.wktWriter.write((Geometry)toWrite);
                }
                if ((toWriteStr = toWrite.toString()).length() > Short.MAX_VALUE) {
                    toWriteStr = toWriteStr.substring(0, 32766);
                    if (this.truncationWarningsGiven < 100) {
                        this.sink.log(PROBLEMS.dataTruncated(member.getKey(), this.rowNumber).withSeverity(Problem.Severity.WARNING));
                        ++this.truncationWarningsGiven;
                        if (this.truncationWarningsGiven == 100) {
                            this.sink.log(PROBLEMS.warningLimitReached(100).withSeverity(Problem.Severity.WARNING));
                        }
                    }
                }
                this.writer.write(this.quote(toWriteStr));
            }
            first = false;
        }
        ++this.rowNumber;
        return first;
    }

    private String quote(String toQuote) {
        boolean requiresQuotes = this.naughtyCharacter.matcher(toQuote).find();
        if (requiresQuotes) {
            String quoted = toQuote.replaceAll("\"", "\"\"");
            return "\"" + quoted + "\"";
        }
        return toQuote;
    }

    private void writeHeaderIfNecessary() throws IOException {
        if (!this.headerWritten) {
            if (this.includeBom) {
                this.writer.write(65279);
            }
            this.writeHeader(this.type, true, new LinkedList<String>());
            this.headerWritten = true;
            this.writer.write(LINE_SEPARATOR);
        }
    }

    private boolean writeHeader(Struct structType, boolean first, LinkedList<String> parents) throws IOException {
        for (Struct.StructMember member : structType.getMembers()) {
            LinkedList<String> toWrite = new LinkedList<String>(parents);
            toWrite.add(member.getKey());
            Struct unwrapped = member.getType().findAllowNull(Struct.class).orElse(null);
            if (unwrapped != null) {
                first = this.writeHeader(unwrapped, first, toWrite);
            } else {
                if (!first) {
                    this.writer.write(SEPARATOR);
                }
                this.writer.write(this.quote(Joiner.on((String)".").join(toWrite)));
            }
            first = false;
        }
        return first;
    }

    @Generated
    public URI getStoredAt() {
        return this.storedAt;
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem dataTruncated(String var1, long var2);

        public Problem warningLimitReached(int var1);
    }
}

