/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.OutputProblems;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.output.PipelineOutputContainer;
import nz.org.riskscape.engine.output.PipelineOutputOptions;
import nz.org.riskscape.engine.output.PipelineOutputStore;
import nz.org.riskscape.engine.output.SinkParameters;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.Manifest;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.sink.SaveSink;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.resource.ResourceFactory;
import nz.org.riskscape.engine.util.StatsWriter;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BasePipelineOutputContainer
implements PipelineOutputContainer {
    protected final PipelineOutputStore store;
    protected final RealizedPipeline pipeline;
    protected final PipelineOutputOptions options;
    protected final Manifest manifest;
    protected final Supplier<LocalDateTime> currentTime;
    protected final Map<String, SaveSink> sinks = new HashMap<String, SaveSink>();
    protected List<Path> fileOutputs = new ArrayList<Path>();
    protected Map<String, URI> movedFileOutputs = new HashMap<String, URI>();
    protected final LocalDateTime startedAt;

    public BasePipelineOutputContainer(PipelineOutputStore store, RealizedPipeline pipeline, PipelineOutputOptions options) {
        this(store, pipeline, options, () -> LocalDateTime.now());
    }

    public BasePipelineOutputContainer(PipelineOutputStore store, RealizedPipeline pipeline, PipelineOutputOptions options, Supplier<LocalDateTime> currentTime) {
        this.store = store;
        this.pipeline = pipeline;
        this.options = options;
        this.currentTime = currentTime;
        this.startedAt = currentTime.get();
        this.manifest = this.buildManifest();
    }

    public ResultOrProblems<Sink> createSinkForStep(SinkParameters params) {
        String sinkName = params.getName();
        if (!params.getFormat().isPresent()) {
            params = new SinkParameters(params);
            params.setFormat(this.options.getFormat());
        }
        return this.createSink(params).map(sink -> {
            this.sinks.put(sinkName, (SaveSink)sink);
            return sink;
        });
    }

    protected abstract ResultOrProblems<SaveSink> createSink(SinkParameters var1);

    public Map<String, URI> getPipelineOutputs() {
        Map sinkURIs = Maps.transformValues(this.sinks, sink -> sink.getStoredAt());
        HashMap<String, URI> combined = new HashMap<String, URI>(sinkURIs);
        combined.putAll(this.movedFileOutputs);
        return combined;
    }

    private Manifest buildManifest() {
        String host;
        Project project = this.pipeline.getContext().getProject();
        Manifest newManifest = new Manifest(this.pipeline, this.startedAt);
        newManifest.versionInfo.add(new Manifest.VersionInfo("Engine", project.getEngine().getBuildInfo().getVersion()));
        for (Plugin plugin : project.getEngine().getPlugins()) {
            PluginDescriptor desc = plugin.getDescriptor();
            newManifest.versionInfo.add(new Manifest.VersionInfo(desc.getPluginId(), desc.getVersion()));
        }
        try {
            InetAddress local = InetAddress.getLocalHost();
            host = local.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            host = "<unknown>";
        }
        String user = System.getProperty("user.name", "<unknown>");
        newManifest.localInfo = new Manifest.LocalInfo(user, host);
        return newManifest;
    }

    protected StatsWriter buildStatsWriter() {
        return new StatsWriter(this.pipeline.getContext().getMetricRegistry());
    }

    protected Optional<String> getPipelineSource() {
        return this.options.getPipelineDeclaration().map(ep -> ep.getBoundary().map(epb -> {
            if (((Token)epb.getLeft()).source.equals(((Token)epb.getRight()).source)) {
                return ((Token)epb.getLeft()).source.substring(((Token)epb.getLeft()).begin, ((Token)epb.getRight()).end);
            }
            return ep.toSource();
        }).orElse(ep.toSource()));
    }

    protected ResourceFactory getResourceFactory() {
        return this.getEngine().getResourceFactory();
    }

    public Project getProject() {
        return this.getExecutionContext().getProject();
    }

    protected Engine getEngine() {
        return this.getProject().getEngine();
    }

    protected ExecutionContext getExecutionContext() {
        return this.pipeline.getContext();
    }

    public void registerLocalFile(Path localFile) {
        for (Path registered : this.fileOutputs) {
            if (!registered.endsWith(localFile.getFileName())) continue;
            this.getProject().getProblemSink().accept(OutputProblems.get().outputAlreadyExists(localFile.getFileName().toString()));
            return;
        }
        this.fileOutputs.add(localFile);
    }

    @Generated
    public PipelineOutputStore getStore() {
        return this.store;
    }

    @Generated
    public RealizedPipeline getPipeline() {
        return this.pipeline;
    }

    @Generated
    public Map<String, SaveSink> getSinks() {
        return this.sinks;
    }
}

