/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseFormat
implements Format {
    private final String id;
    private final String extension;
    private final String mediaType;
    private final EnumSet<Format.Characteristics> characteristics;

    public static boolean containsGeometry(Struct struct) {
        for (Struct.StructMember member : struct.getMembers()) {
            Type memberType = Nullable.strip((Type)member.getType());
            if (memberType.find(Geom.class).isPresent()) {
                return true;
            }
            boolean foundInNested = memberType.find(Struct.class).map(BaseFormat::containsGeometry).orElse(false);
            if (!foundInNested) continue;
            return foundInNested;
        }
        return false;
    }

    public BaseFormat(String id, String extension, String mediaType) {
        this(id, extension, mediaType, EnumSet.noneOf(Format.Characteristics.class));
    }

    public BaseFormat(String id, String extension, String mediaType, Format.Characteristics first, Format.Characteristics ... rest) {
        this(id, extension, mediaType, EnumSet.of(first, rest));
    }

    public String toString() {
        return String.format("Format[id=%s, extension=%s, mediaType=%s]", this.id, this.extension, this.mediaType);
    }

    public ResultOrProblems<? extends Format.FormatOptions> buildOptions(Map<String, List<?>> paramMap, BindingContext context, Struct input) {
        JavaParameterSet parameterSet = JavaParameterSet.fromBindingClass(this.getWriterOptionsClass());
        ProblemPlaceholder givenOptions = ProblemPlaceholder.of(Format.FormatOptions.class, (String)this.getId());
        ResultOrProblems built = parameterSet.bindToObject(context, paramMap).flatMap((bound, probs) -> {
            if (!bound.getExtraneous().isEmpty()) {
                ArrayList problems = new ArrayList();
                List<String> possible = parameterSet.getDeclared().stream().map(Parameter::getName).toList();
                bound.getExtraneous().keySet().stream().forEach(key -> problems.add(GeneralProblems.get().notAnOption(key, (Object)givenOptions, possible)));
                return ResultOrProblems.failed(problems);
            }
            return ResultOrProblems.of((Object)bound, (List)probs);
        }).composeProblems(Problems.foundWith((Object)givenOptions, (Problem[])new Problem[0])).map(bound -> (Format.FormatOptions)bound.getBoundToObject());
        return built;
    }

    public List<String> getRequiredOptions(BindingContext context) {
        JavaParameterSet parameterSet = JavaParameterSet.fromBindingClass(this.getWriterOptionsClass());
        return parameterSet.getDeclared().stream().filter(p -> !p.isOptional() && p.getDefaultValues(context).isEmpty()).map(Parameter::getName).toList();
    }

    @Generated
    public BaseFormat(String id, String extension, String mediaType, EnumSet<Format.Characteristics> characteristics) {
        this.id = id;
        this.extension = extension;
        this.mediaType = mediaType;
        this.characteristics = characteristics;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseFormat)) {
            return false;
        }
        BaseFormat other = (BaseFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseFormat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public EnumSet<Format.Characteristics> getCharacteristics() {
        return this.characteristics;
    }
}

