/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.MessageFactoryProxy;
import nz.org.riskscape.engine.i18n.MessageKey;
import nz.org.riskscape.engine.i18n.MessageSource;

public class MutableMessageSource
implements MessageSource {
    private Map<String, Map<Locale, String>> localeSpecificStore = Maps.newHashMap();
    private Map<String, String> nonSpecificLocaleStore = Maps.newHashMap();

    public String getMessage(MessageKey resolvable) {
        return this.getMessage(resolvable.getCode(), resolvable.getMessageArguments(), resolvable.getDefaultMessage(), Locale.getDefault());
    }

    public String getMessage(MessageKey resolvable, Locale locale) {
        return this.getMessage(resolvable.getCode(), resolvable.getMessageArguments(), resolvable.getDefaultMessage(), locale);
    }

    public String getMessage(String code, Object ... args) {
        return this.getMessage(code, args, Locale.getDefault());
    }

    public String getMessage(String code, Object[] args, Locale locale) {
        return this.getMessage(code, args, null, locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String message = (String)this.localeSpecificStore.getOrDefault(code, Collections.emptyMap()).get(locale);
        if (message == null) {
            message = this.nonSpecificLocaleStore.get(code);
        }
        if (message == null) {
            return defaultMessage;
        }
        return new MessageFormat(message).format(args);
    }

    public void addMessage(String code, String messageFormat) {
        this.nonSpecificLocaleStore.put(code, messageFormat);
    }

    public void addMessage(Locale locale, String code, String messageFormat) {
        this.localeSpecificStore.computeIfAbsent(code, k -> new HashMap()).put(locale, messageFormat);
    }

    public <T extends MessageFactory> T getMessageFactory(Class<T> factory, Locale locale) {
        return MessageFactoryProxy.getMessageFactory(factory, locale, this);
    }
}

